/*
 * Copyright (c) 2019, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang.reflect;


/**
 * A {@code RecordComponent} provides information about, and dynamic access to, a
 * component of a record class.
 *
 * @see java.lang.Class#getRecordComponents()
 * @see java.lang.Record
 * @jls 8.10 Record Classes
 * @since 16
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RecordComponent implements java.lang.reflect.AnnotatedElement {

RecordComponent() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of this record component.
 *
 * @return the name of this record component
 */

@androidx.annotation.RecentlyNonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@code Class} that identifies the declared type for this
 * record component.
 *
 * @return a {@code Class} identifying the declared type of the component
 * represented by this record component
 */

@androidx.annotation.RecentlyNonNull
public java.lang.Class<?> getType() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@code String} that describes the generic type signature for
 * this record component.
 *
 * @return a {@code String} that describes the generic type signature for
 * this record component
 *
 * @jvms 4.7.9.1 Signatures
 */

@androidx.annotation.RecentlyNullable
public java.lang.String getGenericSignature() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@code Type} object that represents the declared type for
 * this record component.
 *
 * <p>If the declared type of the record component is a parameterized type,
 * the {@code Type} object returned reflects the actual type arguments used
 * in the source code.
 *
 * <p>If the type of the underlying record component is a type variable or a
 * parameterized type, it is created. Otherwise, it is resolved.
 *
 * @return a {@code Type} object that represents the declared type for
 *         this record component
 * @throws java.lang.reflect.GenericSignatureFormatError if the generic record component
 *         signature does not conform to the format specified in
 *         <cite>The Java Virtual Machine Specification</cite>
 * @throws java.lang.TypeNotPresentException if the generic type
 *         signature of the underlying record component refers to a non-existent
 *         type declaration
 * @throws java.lang.reflect.MalformedParameterizedTypeException if the generic
 *         signature of the underlying record component refers to a parameterized
 *         type that cannot be instantiated for any reason
 */

@androidx.annotation.RecentlyNonNull
public java.lang.reflect.Type getGenericType() { throw new RuntimeException("Stub!"); }

/**
 * Returns a {@code Method} that represents the accessor for this record
 * component.
 *
 * @return a {@code Method} that represents the accessor for this record
 * component
 */

@androidx.annotation.RecentlyNonNull
public java.lang.reflect.Method getAccessor() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <p>Note that any annotation returned by this method is a
 * declaration annotation.
 * @throws java.lang.NullPointerException {@inheritDoc}
 */

@androidx.annotation.RecentlyNullable
public <T extends java.lang.annotation.Annotation> T getAnnotation(@androidx.annotation.RecentlyNonNull java.lang.Class<T> annotationClass) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <p>Note that any annotations returned by this method are
 * declaration annotations.
 */

@androidx.annotation.RecentlyNonNull
public java.lang.annotation.Annotation[] getAnnotations() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}
 * <p>Note that any annotations returned by this method are
 * declaration annotations.
 */

@androidx.annotation.RecentlyNonNull
public java.lang.annotation.Annotation[] getDeclaredAnnotations() { throw new RuntimeException("Stub!"); }

/**
 * Returns a string describing this record component. The format is
 * the record component type, followed by a space, followed by the name
 * of the record component.
 * For example:
 * <pre>
 *    java.lang.String name
 *    int age
 * </pre>
 *
 * @return a string describing this record component
 */

@androidx.annotation.RecentlyNonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Returns the record class which declares this record component.
 *
 * @return The record class declaring this record component.
 */

@androidx.annotation.RecentlyNonNull
public java.lang.Class<?> getDeclaringRecord() { throw new RuntimeException("Stub!"); }
}

