/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1995, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.lang;

import java.io.*;
import java.util.StringTokenizer;

/**
 * Every Java application has a single instance of class
 * {@code Runtime} that allows the application to interface with
 * the environment in which the application is running. The current
 * runtime can be obtained from the {@code getRuntime} method.
 * <p>
 * An application cannot create its own instance of this class.
 *
 * @author  unascribed
 * @see     java.lang.Runtime#getRuntime()
 * @since   1.0
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Runtime {

Runtime() { throw new RuntimeException("Stub!"); }

/**
 * Returns the runtime object associated with the current Java application.
 * Most of the methods of class {@code Runtime} are instance
 * methods and must be invoked with respect to the current runtime object.
 *
 * @return  the {@code Runtime} object associated with the current
 *          Java application.
 */

public static java.lang.Runtime getRuntime() { throw new RuntimeException("Stub!"); }

/**
 * Terminates the currently running Java virtual machine by initiating its
 * shutdown sequence.  This method never returns normally.  The argument
 * serves as a status code; by convention, a nonzero status code indicates
 * abnormal termination.
 *
 * <p> All registered {@linkplain #addShutdownHook shutdown hooks}, if any,
 * are started in some unspecified order and allowed to run concurrently
 * until they finish.  Once this is done the virtual machine
 * {@linkplain #halt halts}.
 *
 * <p> If this method is invoked after all shutdown hooks have already
 * been run and the status is nonzero then this method halts the
 * virtual machine with the given status code. Otherwise, this method
 * blocks indefinitely.
 *
 * <p> The {@link java.lang.System#exit(int) System.exit} method is the
 * conventional and convenient means of invoking this method.
 *
 * @param  status
 *         Termination status.  By convention, a nonzero status code
 *         indicates abnormal termination.
 *
 * @throws java.lang.SecurityException
 *         If a security manager is present and its
 *         {@link java.lang.SecurityManager#checkExit checkExit} method does not permit
 *         exiting with the specified status
 *
 * @see java.lang.SecurityException
 * @see java.lang.SecurityManager#checkExit(int)
 * @see #addShutdownHook
 * @see #removeShutdownHook
 * @see #halt(int)
 */

public void exit(int status) { throw new RuntimeException("Stub!"); }

/**
 * Registers a new virtual-machine shutdown hook.
 *
 * <p> The Java virtual machine <i>shuts down</i> in response to two kinds
 * of events:
 *
 *   <ul>
 *
 *   <li> The program <i>exits</i> normally, when the last non-daemon
 *   thread exits or when the {@link #exit exit} (equivalently,
 *   {@link java.lang.System#exit(int) System.exit}) method is invoked, or
 *
 *   <li> The virtual machine is <i>terminated</i> in response to a
 *   user interrupt, such as typing {@code ^C}, or a system-wide event,
 *   such as user logoff or system shutdown.
 *
 *   </ul>
 *
 * <p> A <i>shutdown hook</i> is simply an initialized but unstarted
 * thread.  When the virtual machine begins its shutdown sequence it will
 * start all registered shutdown hooks in some unspecified order and let
 * them run concurrently.  When all the hooks have finished it will then
 * halt. Note that daemon threads will continue to run during the shutdown
 * sequence, as will non-daemon threads if shutdown was initiated by
 * invoking the {@link #exit exit} method.
 *
 * <p> Once the shutdown sequence has begun it can be stopped only by
 * invoking the {@link #halt halt} method, which forcibly
 * terminates the virtual machine.
 *
 * <p> Once the shutdown sequence has begun it is impossible to register a
 * new shutdown hook or de-register a previously-registered hook.
 * Attempting either of these operations will cause an
 * {@link java.lang.IllegalStateException IllegalStateException} to be thrown.
 *
 * <p> Shutdown hooks run at a delicate time in the life cycle of a virtual
 * machine and should therefore be coded defensively.  They should, in
 * particular, be written to be thread-safe and to avoid deadlocks insofar
 * as possible.  They should also not rely blindly upon services that may
 * have registered their own shutdown hooks and therefore may themselves in
 * the process of shutting down.  Attempts to use other thread-based
 * services such as the AWT event-dispatch thread, for example, may lead to
 * deadlocks.
 *
 * <p> Shutdown hooks should also finish their work quickly.  When a
 * program invokes {@link #exit exit} the expectation is
 * that the virtual machine will promptly shut down and exit.  When the
 * virtual machine is terminated due to user logoff or system shutdown the
 * underlying operating system may only allow a fixed amount of time in
 * which to shut down and exit.  It is therefore inadvisable to attempt any
 * user interaction or to perform a long-running computation in a shutdown
 * hook.
 *
 * <p> Uncaught exceptions are handled in shutdown hooks just as in any
 * other thread, by invoking the
 * {@link java.lang.ThreadGroup#uncaughtException uncaughtException} method of the
 * thread's {@link java.lang.ThreadGroup ThreadGroup} object. The default implementation of this
 * method prints the exception's stack trace to {@link java.lang.System#err System#err} and
 * terminates the thread; it does not cause the virtual machine to exit or
 * halt.
 *
 * <p> In rare circumstances the virtual machine may <i>abort</i>, that is,
 * stop running without shutting down cleanly.  This occurs when the
 * virtual machine is terminated externally, for example with the
 * {@code SIGKILL} signal on Unix or the {@code TerminateProcess} call on
 * Microsoft Windows.  The virtual machine may also abort if a native
 * method goes awry by, for example, corrupting internal data structures or
 * attempting to access nonexistent memory.  If the virtual machine aborts
 * then no guarantee can be made about whether or not any shutdown hooks
 * will be run.
 *
 * @param   hook
 *          An initialized but unstarted {@link java.lang.Thread Thread} object
 *
 * @throws  java.lang.IllegalArgumentException
 *          If the specified hook has already been registered,
 *          or if it can be determined that the hook is already running or
 *          has already been run
 *
 * @throws  java.lang.IllegalStateException
 *          If the virtual machine is already in the process
 *          of shutting down
 *
 * @throws  java.lang.SecurityException
 *          If a security manager is present and it denies
 *          {@link java.lang.RuntimePermission RuntimePermission}("shutdownHooks")
 *
 * @see #removeShutdownHook
 * @see #halt(int)
 * @see #exit(int)
 * @since 1.3
 */

public void addShutdownHook(java.lang.Thread hook) { throw new RuntimeException("Stub!"); }

/**
 * De-registers a previously-registered virtual-machine shutdown hook.
 *
 * @param hook the hook to remove
 * @return {@code true} if the specified hook had previously been
 * registered and was successfully de-registered, {@code false}
 * otherwise.
 *
 * @throws  java.lang.IllegalStateException
 *          If the virtual machine is already in the process of shutting
 *          down
 *
 * @throws  java.lang.SecurityException
 *          If a security manager is present and it denies
 *          {@link java.lang.RuntimePermission RuntimePermission}("shutdownHooks")
 *
 * @see #addShutdownHook
 * @see #exit(int)
 * @since 1.3
 */

public boolean removeShutdownHook(java.lang.Thread hook) { throw new RuntimeException("Stub!"); }

/**
 * Forcibly terminates the currently running Java virtual machine.  This
 * method never returns normally.
 *
 * <p> This method should be used with extreme caution.  Unlike the
 * {@link #exit exit} method, this method does not cause shutdown
 * hooks to be started.  If the shutdown sequence has already been
 * initiated then this method does not wait for any running
 * shutdown hooks to finish their work.
 *
 * @param  status
 *         Termination status. By convention, a nonzero status code
 *         indicates abnormal termination. If the {@link java.lang.Runtime#exit exit}
 *         (equivalently, {@link java.lang.System#exit(int) System.exit}) method
 *         has already been invoked then this status code
 *         will override the status code passed to that method.
 *
 * @throws java.lang.SecurityException
 *         If a security manager is present and its
 *         {@link java.lang.SecurityManager#checkExit checkExit} method
 *         does not permit an exit with the specified status
 *
 * @see #exit
 * @see #addShutdownHook
 * @see #removeShutdownHook
 * @since 1.3
 */

public void halt(int status) { throw new RuntimeException("Stub!"); }

/**
 * Enable or disable finalization on exit; doing so specifies that the
 * finalizers of all objects that have finalizers that have not yet been
 * automatically invoked are to be run before the Java runtime exits.
 * By default, finalization on exit is disabled.
 *
 * <p>If there is a security manager,
 * its <code>checkExit</code> method is first called
 * with 0 as its argument to ensure the exit is allowed.
 * This could result in a SecurityException.
 *
 * @param value true to enable finalization on exit, false to disable
 * @deprecated  This method is inherently unsafe.  It may result in
 *      finalizers being called on live objects while other threads are
 *      concurrently manipulating those objects, resulting in erratic
 *      behavior or deadlock.
 *
 * @throws  java.lang.SecurityException
 *        if a security manager exists and its <code>checkExit</code>
 *        method doesn't allow the exit.
 *
 * @see     java.lang.Runtime#exit(int)
 * @see     java.lang.Runtime#gc()
 * @see     java.lang.SecurityManager#checkExit(int)
 * @since   JDK1.1
 */

@Deprecated
public static void runFinalizersOnExit(boolean value) { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified string command in a separate process.
 *
 * <p>This is a convenience method.  An invocation of the form
 * {@code exec(command)}
 * behaves in exactly the same way as the invocation
 * {@link #exec(java.lang.String,java.lang.String[],java.io.File) exec}{@code (command, null, null)}.
 *
 * @param   command   a specified system command.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code command} is {@code null}
 *
 * @throws  java.lang.IllegalArgumentException
 *          If {@code command} is empty
 *
 * @see     #exec(String[], String[], File)
 * @see     java.lang.ProcessBuilder
 */

public java.lang.Process exec(java.lang.String command) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified string command in a separate process with the
 * specified environment.
 *
 * <p>This is a convenience method.  An invocation of the form
 * {@code exec(command, envp)}
 * behaves in exactly the same way as the invocation
 * {@link #exec(java.lang.String,java.lang.String[],java.io.File) exec}{@code (command, envp, null)}.
 *
 * @param   command   a specified system command.
 *
 * @param   envp      array of strings, each element of which
 *                    has environment variable settings in the format
 *                    <i>name</i>=<i>value</i>, or
 *                    {@code null} if the subprocess should inherit
 *                    the environment of the current process.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code command} is {@code null},
 *          or one of the elements of {@code envp} is {@code null}
 *
 * @throws  java.lang.IllegalArgumentException
 *          If {@code command} is empty
 *
 * @see     #exec(String[], String[], File)
 * @see     java.lang.ProcessBuilder
 */

public java.lang.Process exec(java.lang.String command, java.lang.String[] envp) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified string command in a separate process with the
 * specified environment and working directory.
 *
 * <p>This is a convenience method.  An invocation of the form
 * {@code exec(command, envp, dir)}
 * behaves in exactly the same way as the invocation
 * {@link #exec(java.lang.String[],java.lang.String[],java.io.File) exec}{@code (cmdarray, envp, dir)},
 * where {@code cmdarray} is an array of all the tokens in
 * {@code command}.
 *
 * <p>More precisely, the {@code command} string is broken
 * into tokens using a {@link java.util.StringTokenizer StringTokenizer} created by the call
 * {@code new {@link StringTokenizer}(command)} with no
 * further modification of the character categories.  The tokens
 * produced by the tokenizer are then placed in the new string
 * array {@code cmdarray}, in the same order.
 *
 * @param   command   a specified system command.
 *
 * @param   envp      array of strings, each element of which
 *                    has environment variable settings in the format
 *                    <i>name</i>=<i>value</i>, or
 *                    {@code null} if the subprocess should inherit
 *                    the environment of the current process.
 *
 * @param   dir       the working directory of the subprocess, or
 *                    {@code null} if the subprocess should inherit
 *                    the working directory of the current process.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code command} is {@code null},
 *          or one of the elements of {@code envp} is {@code null}
 *
 * @throws  java.lang.IllegalArgumentException
 *          If {@code command} is empty
 *
 * @see     java.lang.ProcessBuilder
 * @since 1.3
 */

public java.lang.Process exec(java.lang.String command, java.lang.String[] envp, java.io.File dir) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified command and arguments in a separate process.
 *
 * <p>This is a convenience method.  An invocation of the form
 * {@code exec(cmdarray)}
 * behaves in exactly the same way as the invocation
 * {@link #exec(java.lang.String[],java.lang.String[],java.io.File) exec}{@code (cmdarray, null, null)}.
 *
 * @param   cmdarray  array containing the command to call and
 *                    its arguments.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code cmdarray} is {@code null},
 *          or one of the elements of {@code cmdarray} is {@code null}
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code cmdarray} is an empty array
 *          (has length {@code 0})
 *
 * @see     java.lang.ProcessBuilder
 */

public java.lang.Process exec(java.lang.String[] cmdarray) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified command and arguments in a separate process
 * with the specified environment.
 *
 * <p>This is a convenience method.  An invocation of the form
 * {@code exec(cmdarray, envp)}
 * behaves in exactly the same way as the invocation
 * {@link #exec(java.lang.String[],java.lang.String[],java.io.File) exec}{@code (cmdarray, envp, null)}.
 *
 * @param   cmdarray  array containing the command to call and
 *                    its arguments.
 *
 * @param   envp      array of strings, each element of which
 *                    has environment variable settings in the format
 *                    <i>name</i>=<i>value</i>, or
 *                    {@code null} if the subprocess should inherit
 *                    the environment of the current process.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code cmdarray} is {@code null},
 *          or one of the elements of {@code cmdarray} is {@code null},
 *          or one of the elements of {@code envp} is {@code null}
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code cmdarray} is an empty array
 *          (has length {@code 0})
 *
 * @see     java.lang.ProcessBuilder
 */

public java.lang.Process exec(java.lang.String[] cmdarray, java.lang.String[] envp) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Executes the specified command and arguments in a separate process with
 * the specified environment and working directory.
 *
 * <p>Given an array of strings {@code cmdarray}, representing the
 * tokens of a command line, and an array of strings {@code envp},
 * representing "environment" variable settings, this method creates
 * a new process in which to execute the specified command.
 *
 * <p>This method checks that {@code cmdarray} is a valid operating
 * system command.  Which commands are valid is system-dependent,
 * but at the very least the command must be a non-empty list of
 * non-null strings.
 *
 * <p>If {@code envp} is {@code null}, the subprocess inherits the
 * environment settings of the current process.
 *
 * <p>A minimal set of system dependent environment variables may
 * be required to start a process on some operating systems.
 * As a result, the subprocess may inherit additional environment variable
 * settings beyond those in the specified environment.
 *
 * <p>{@link java.lang.ProcessBuilder#start() ProcessBuilder#start()} is now the preferred way to
 * start a process with a modified environment.
 *
 * <p>The working directory of the new subprocess is specified by {@code dir}.
 * If {@code dir} is {@code null}, the subprocess inherits the
 * current working directory of the current process.
 *
 * <p>If a security manager exists, its
 * {@link java.lang.SecurityManager#checkExec checkExec}
 * method is invoked with the first component of the array
 * {@code cmdarray} as its argument. This may result in a
 * {@link java.lang.SecurityException SecurityException} being thrown.
 *
 * <p>Starting an operating system process is highly system-dependent.
 * Among the many things that can go wrong are:
 * <ul>
 * <li>The operating system program file was not found.
 * <li>Access to the program file was denied.
 * <li>The working directory does not exist.
 * </ul>
 *
 * <p>In such cases an exception will be thrown.  The exact nature
 * of the exception is system-dependent, but it will always be a
 * subclass of {@link java.io.IOException IOException}.
 *
 * <p>If the operating system does not support the creation of
 * processes, an {@link java.lang.UnsupportedOperationException UnsupportedOperationException} will be thrown.
 *
 *
 * @param   cmdarray  array containing the command to call and
 *                    its arguments.
 *
 * @param   envp      array of strings, each element of which
 *                    has environment variable settings in the format
 *                    <i>name</i>=<i>value</i>, or
 *                    {@code null} if the subprocess should inherit
 *                    the environment of the current process.
 *
 * @param   dir       the working directory of the subprocess, or
 *                    {@code null} if the subprocess should inherit
 *                    the working directory of the current process.
 *
 * @return  A new {@link java.lang.Process Process} object for managing the subprocess
 *
 * @throws  java.lang.SecurityException
 *          If a security manager exists and its
 *          {@link java.lang.SecurityManager#checkExec checkExec}
 *          method doesn't allow creation of the subprocess
 *
 * @throws  java.lang.UnsupportedOperationException
 *          If the operating system does not support the creation of processes.
 *
 * @throws  java.io.IOException
 *          If an I/O error occurs
 *
 * @throws  java.lang.NullPointerException
 *          If {@code cmdarray} is {@code null},
 *          or one of the elements of {@code cmdarray} is {@code null},
 *          or one of the elements of {@code envp} is {@code null}
 *
 * @throws  java.lang.IndexOutOfBoundsException
 *          If {@code cmdarray} is an empty array
 *          (has length {@code 0})
 *
 * @see     java.lang.ProcessBuilder
 * @since 1.3
 */

public java.lang.Process exec(java.lang.String[] cmdarray, java.lang.String[] envp, java.io.File dir) throws java.io.IOException { throw new RuntimeException("Stub!"); }

/**
 * Returns the number of processors available to the Java virtual machine.
 *
 * <p> This value may change during a particular invocation of the virtual
 * machine.  Applications that are sensitive to the number of available
 * processors should therefore occasionally poll this property and adjust
 * their resource usage appropriately. </p>
 *
 * @return  the maximum number of processors available to the virtual
 *          machine; never smaller than one
 * @since 1.4
 */

public int availableProcessors() { throw new RuntimeException("Stub!"); }

/**
 * Returns the amount of free memory in the Java Virtual Machine.
 * Calling the
 * {@code gc} method may result in increasing the value returned
 * by {@code freeMemory.}
 *
 * @return  an approximation to the total amount of memory currently
 *          available for future allocated objects, measured in bytes.
 */

public native long freeMemory();

/**
 * Returns the total amount of memory in the Java virtual machine.
 * The value returned by this method may vary over time, depending on
 * the host environment.
 * <p>
 * Note that the amount of memory required to hold an object of any
 * given type may be implementation-dependent.
 *
 * @return  the total amount of memory currently available for current
 *          and future objects, measured in bytes.
 */

public native long totalMemory();

/**
 * Returns the maximum amount of memory that the Java virtual machine
 * will attempt to use.  If there is no inherent limit then the value
 * {@link java.lang.Long#MAX_VALUE} will be returned.
 *
 * @return  the maximum amount of memory that the virtual machine will
 *          attempt to use, measured in bytes
 * @since 1.4
 */

public native long maxMemory();

/**
 * Runs the garbage collector.
 * Calling this method suggests that the Java virtual machine expend
 * effort toward recycling unused objects in order to make the memory
 * they currently occupy available for quick reuse. When control
 * returns from the method call, the virtual machine has made
 * its best effort to recycle all discarded objects.
 * <p>
 * The name {@code gc} stands for "garbage
 * collector". The virtual machine performs this recycling
 * process automatically as needed, in a separate thread, even if the
 * {@code gc} method is not invoked explicitly.
 * <p>
 * The method {@link java.lang.System#gc() System#gc()} is the conventional and convenient
 * means of invoking this method.
 */

public void gc() { throw new RuntimeException("Stub!"); }

/**
 * Runs the finalization methods of any objects pending finalization.
 * Calling this method suggests that the Java virtual machine expend
 * effort toward running the {@code finalize} methods of objects
 * that have been found to be discarded but whose {@code finalize}
 * methods have not yet been run. When control returns from the
 * method call, the virtual machine has made a best effort to
 * complete all outstanding finalizations.
 * <p>
 * The virtual machine performs the finalization process
 * automatically as needed, in a separate thread, if the
 * {@code runFinalization} method is not invoked explicitly.
 * <p>
 * The method {@link java.lang.System#runFinalization() System#runFinalization()} is the conventional
 * and convenient means of invoking this method.
 *
 * @see     java.lang.Object#finalize()
 */

public void runFinalization() { throw new RuntimeException("Stub!"); }

/**
 * Not implemented, does nothing.
 *
 * @deprecated
 * This method was intended to control instruction tracing.
 * It has been superseded by ART-specific tracing mechanisms.
 *
 * @param on ignored
 */

@Deprecated
public void traceInstructions(boolean on) { throw new RuntimeException("Stub!"); }

/**
 * Not implemented, does nothing.
 * <p>
 * Calling this method on Android Lollipop or later (API level >= 21)
 * with {@code true} argument will cause it to throw an
 * {@code UnsupportedOperationException}.
 *
 * @deprecated
 * This method was intended to control method call tracing.
 * It has been superseded by ART-specific tracing mechanisms.
 *
 * @param on ignored
 */

@Deprecated
public void traceMethodCalls(boolean on) { throw new RuntimeException("Stub!"); }

/**
 * Loads the native library specified by the filename argument.  The filename
 * argument must be an absolute path name.
 * (for example
 * {@code Runtime.getRuntime().load("/home/avh/lib/libX11.so");}).
 *
 * If the filename argument, when stripped of any platform-specific library
 * prefix, path, and file extension, indicates a library whose name is,
 * for example, L, and a native library called L is statically linked
 * with the VM, then the JNI_OnLoad_L function exported by the library
 * is invoked rather than attempting to load a dynamic library.
 * A filename matching the argument does not have to exist in the file
 * system.
 * See the <a href="https://docs.oracle.com/en/java/javase/17/docs/specs/jni/index.html"> JNI Specification</a>
 * for more details.
 *
 * Otherwise, the filename argument is mapped to a native library image in
 * an implementation-dependent manner.
 * <p>
 * First, if there is a security manager, its {@code checkLink}
 * method is called with the {@code filename} as its argument.
 * This may result in a security exception.
 * <p>
 * This is similar to the method {@link #loadLibrary(java.lang.String)}, but it
 * accepts a general file name as an argument rather than just a library
 * name, allowing any file of native code to be loaded.
 * <p>
 * The method {@link java.lang.System#load(java.lang.String) System#load(String)} is the conventional and
 * convenient means of invoking this method.
 *
 * @param      filename   the file to load.
 * @throws     java.lang.SecurityException  if a security manager exists and its
 *             {@code checkLink} method doesn't allow
 *             loading of the specified dynamic library
 * @throws     java.lang.UnsatisfiedLinkError  if either the filename is not an
 *             absolute path name, the native library is not statically
 *             linked with the VM, or the library cannot be mapped to
 *             a native library image by the host system.
 * @throws     java.lang.NullPointerException if {@code filename} is
 *             {@code null}
 * @see        java.lang.Runtime#getRuntime()
 * @see        java.lang.SecurityException
 * @see        java.lang.SecurityManager#checkLink(java.lang.String)
 */

public void load(java.lang.String filename) { throw new RuntimeException("Stub!"); }

/**
 * Loads the native library specified by the {@code libname}
 * argument.  The {@code libname} argument must not contain any platform
 * specific prefix, file extension or path. If a native library
 * called {@code libname} is statically linked with the VM, then the
 * JNI_OnLoad_{@code libname} function exported by the library is invoked.
 * See the <a href="https://docs.oracle.com/en/java/javase/17/docs/specs/jni/index.html"> JNI Specification</a>
 * for more details.
 *
 * Otherwise, the libname argument is loaded from a system library
 * location and mapped to a native library image in an implementation-
 * dependent manner.
 * <p>
 * First, if there is a security manager, its {@code checkLink}
 * method is called with the {@code libname} as its argument.
 * This may result in a security exception.
 * <p>
 * The method {@link java.lang.System#loadLibrary(java.lang.String) System#loadLibrary(String)} is the conventional
 * and convenient means of invoking this method. If native
 * methods are to be used in the implementation of a class, a standard
 * strategy is to put the native code in a library file (call it
 * {@code LibFile}) and then to put a static initializer:
 * <blockquote><pre>
 * static { System.loadLibrary("LibFile"); }
 * </pre></blockquote>
 * within the class declaration. When the class is loaded and
 * initialized, the necessary native code implementation for the native
 * methods will then be loaded as well.
 * <p>
 * If this method is called more than once with the same library
 * name, the second and subsequent calls are ignored.
 *
 * @param      libname   the name of the library.
 * @throws     java.lang.SecurityException  if a security manager exists and its
 *             {@code checkLink} method doesn't allow
 *             loading of the specified dynamic library
 * @throws     java.lang.UnsatisfiedLinkError if either the libname argument
 *             contains a file path, the native library is not statically
 *             linked with the VM,  or the library cannot be mapped to a
 *             native library image by the host system.
 * @throws     java.lang.NullPointerException if {@code libname} is
 *             {@code null}
 * @see        java.lang.SecurityException
 * @see        java.lang.SecurityManager#checkLink(java.lang.String)
 */

public void loadLibrary(java.lang.String libname) { throw new RuntimeException("Stub!"); }
}

