/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface Menu {

public android.view.MenuItem add(java.lang.CharSequence title);

public android.view.MenuItem add(int titleRes);

public android.view.MenuItem add(int groupId, int itemId, int order, java.lang.CharSequence title);

public android.view.MenuItem add(int groupId, int itemId, int order, int titleRes);

public android.view.SubMenu addSubMenu(java.lang.CharSequence title);

public android.view.SubMenu addSubMenu(int titleRes);

public android.view.SubMenu addSubMenu(int groupId, int itemId, int order, java.lang.CharSequence title);

public android.view.SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes);

public int addIntentOptions(int groupId, int itemId, int order, android.content.ComponentName caller, android.content.Intent[] specifics, android.content.Intent intent, int flags, android.view.MenuItem[] outSpecificItems);

public void removeItem(int id);

public void removeGroup(int groupId);

public void clear();

public void setGroupCheckable(int group, boolean checkable, boolean exclusive);

public void setGroupVisible(int group, boolean visible);

public void setGroupEnabled(int group, boolean enabled);

public boolean hasVisibleItems();

public android.view.MenuItem findItem(int id);

public int size();

public android.view.MenuItem getItem(int index);

public void close();

public boolean performShortcut(int keyCode, android.view.KeyEvent event, int flags);

public boolean isShortcutKey(int keyCode, android.view.KeyEvent event);

public boolean performIdentifierAction(int id, int flags);

public void setQwertyMode(boolean isQwerty);

public default void setGroupDividerEnabled(boolean groupDividerEnabled) { throw new RuntimeException("Stub!"); }

public static final int CATEGORY_ALTERNATIVE = 262144; // 0x40000

public static final int CATEGORY_CONTAINER = 65536; // 0x10000

public static final int CATEGORY_SECONDARY = 196608; // 0x30000

public static final int CATEGORY_SYSTEM = 131072; // 0x20000

public static final int FIRST = 1; // 0x1

public static final int FLAG_ALWAYS_PERFORM_CLOSE = 2; // 0x2

public static final int FLAG_APPEND_TO_GROUP = 1; // 0x1

public static final int FLAG_PERFORM_NO_CLOSE = 1; // 0x1

public static final int NONE = 0; // 0x0

public static final int SUPPORTED_MODIFIERS_MASK = 69647; // 0x1100f
}

