/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi.aware;


/**
 * Wi-Fi Aware data-path security config. The config is used with
 * {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder#setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig) WifiAwareNetworkSpecifier.Builder#setDataPathSecurityConfig(WifiAwareDataPathSecurityConfig)}
 * to request a secure data-path.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class WifiAwareDataPathSecurityConfig implements android.os.Parcelable {

WifiAwareDataPathSecurityConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * Get the cipher suite specified in this config
 * @return one of {@code Characteristics#WIFI_AWARE_CIPHER_SUITE_*"}

 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NONE}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128}, and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}
 */

public int getCipherSuite() { throw new RuntimeException("Stub!"); }

/**
 * Get the specified PMK in this config.
 * @see android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder#setPmk(byte[])
 * @return A PMK (pairwise master key, see IEEE 802.11i) specifying the key to use for
 * encrypting the data-path.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getPmk() { throw new RuntimeException("Stub!"); }

/**
 * Get the specified PMKID in this config.
 * @return A PMKID (pairwise master key associated identifier, see IEEE 802.11) is generated
 * by Diffie-Hellman key exchange together with a Pairwise Master Key.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public byte[] getPmkId() { throw new RuntimeException("Stub!"); }

/**
 * Get the specified passphrase in this config.
 * @return The passphrase to be used to encrypt the link.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.lang.String getPskPassphrase() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.wifi.aware.WifiAwareDataPathSecurityConfig> CREATOR;
static { CREATOR = null; }
/**
 * A builder class for a Wi-Fi Aware data-path security config to encrypt an Aware connection.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Create a builder for a Wi-Fi Aware data-path security config to encrypt the link with
 * specified cipher suite. Use {@link android.net.wifi.aware.Characteristics#getSupportedCipherSuites() Characteristics#getSupportedCipherSuites()} to get the
 * supported capabilities of the device.
 * <ul>
 * <li>For shared key cipher suite
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, either passphrase or PMK must
 * be set.</li>
 * <li>For public key cipher suite
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}. Both PMK and PMKID must be
 * set.</li>
 * </ul>
 * @see android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder#setDataPathSecurityConfig(WifiAwareDataPathSecurityConfig)
 * @param cipherSuite The cipher suite to be used to encrypt the link. One of the
 *                    {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128},
 *                    {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256},
 *                    {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128} and
 *                    {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}.

 * Value is either <code>0</code> or a combination of {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NONE}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128}, and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}
 */

public Builder(int cipherSuite) { throw new RuntimeException("Stub!"); }

/**
 * Configure the PSK Passphrase for the Wi-Fi Aware connection being requested. For shared
 * key cipher suite {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, either passphrase or PMK must
 * be set.
 *
 * @param pskPassphrase The passphrase to be used to encrypt the link. Alternatively, use
 *                      the {@link #setPmk(byte[])} to specify a PMK for shared key cipher
 *                      suite.
 * @return the current {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder Builder} builder, enabling chaining of builder methods.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder setPskPassphrase(@android.annotation.NonNull java.lang.String pskPassphrase) { throw new RuntimeException("Stub!"); }

/**
 * Configure the PMK for the Wi-Fi Aware connection being requested. For shared key cipher
 * suite {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_SK_256}, either passphrase or PMK must
 * be set.
 * For public key cipher suite {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128}
 * and {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}. Both PMK and PMKID must
 * be set.
 *
 * @param pmk A PMK (pairwise master key, see IEEE 802.11i) specifying the key to use for
 *            encrypting the data-path. Alternatively, use the
 *            {@link #setPskPassphrase(java.lang.String)} to specify a Passphrase instead for shared
 *            key cipher suite. Use the {@link #setPmkId(byte[])} together for public key
 *            cipher suite.
 * @return the current {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder Builder} builder, enabling chaining of builder
 *         methods.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder setPmk(@android.annotation.NonNull byte[] pmk) { throw new RuntimeException("Stub!"); }

/**
 * Configure the PMKID for the Wi-Fi Aware connection being requested. For public key cipher
 * suite {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_128} and
 * {@link android.net.wifi.aware.Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256 Characteristics#WIFI_AWARE_CIPHER_SUITE_NCS_PK_256}. both PMK and PMKID must set
 * {@link #setPmk(byte[])}
 *
 * @param pmkId A PMKID (pairwise master key associated identifier, see IEEE 802.11) is
 *              generated by Diffie-Hellman key exchange together with a Pairwise Master Key
 *              (PMK), specifying the identifier associated to the key to use for encrypting
 *              the data-path. Use the  {@link #setPmk(byte[])} together for public key
 *              cipher suite.
 * @return the current {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder Builder} builder, enabling chaining of builder
 *         methods.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareDataPathSecurityConfig.Builder setPmkId(@android.annotation.NonNull byte[] pmkId) { throw new RuntimeException("Stub!"); }

/**
 * Create a {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig WifiAwareDataPathSecurityConfig} to set in
 * {@link android.net.wifi.aware.WifiAwareNetworkSpecifier.Builder#setDataPathSecurityConfig(android.net.wifi.aware.WifiAwareDataPathSecurityConfig) WifiAwareNetworkSpecifier.Builder#setDataPathSecurityConfig(WifiAwareDataPathSecurityConfig)} to encrypt the link.
 * @return A {@link android.net.wifi.aware.WifiAwareDataPathSecurityConfig WifiAwareDataPathSecurityConfig} to be used for encrypting the Wi-Fi
 * Aware data-path.
 */

@android.annotation.NonNull
public android.net.wifi.aware.WifiAwareDataPathSecurityConfig build() { throw new RuntimeException("Stub!"); }
}

}

