/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.wifi;


/**
 * Easy Connect (DPP) Status Callback. Use this callback to get status updates (success, failure,
 * progress) from the Easy Connect operations.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class EasyConnectStatusCallback {

EasyConnectStatusCallback() { throw new RuntimeException("Stub!"); }

/**
 * Easy Connect Failure event: Bootstrapping/Authentication initialization process failure.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_AUTHENTICATION = -2; // 0xfffffffe

/**
 * Easy Connect Failure event: Easy Connect request while in another Easy Connect exchange.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_BUSY = -5; // 0xfffffffb

/**
 * Easy Connect R2 Failure event: Enrollee cannot find the network.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_CANNOT_FIND_NETWORK = -10; // 0xfffffff6

/**
 * Easy Connect Failure event: Configuration process has failed due to malformed message.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_CONFIGURATION = -4; // 0xfffffffc

/**
 * Easy Connect R2 Failure event: Enrollee failed to authenticate with the network.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_ENROLLEE_AUTHENTICATION = -11; // 0xfffffff5

/**
 * Easy Connect Failure event: Enrollee didn't scan the network's operating channel.
 * This error is generated when framework finds that Network's operating channel
 * is not included in the list of channels the Enrollee scanned in attempting to
 * discover the network prior to connection.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_ENROLLEE_FAILED_TO_SCAN_NETWORK_CHANNEL = -14; // 0xfffffff2

/**
 * Easy Connect R2 Failure event: Enrollee rejected the configuration.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_ENROLLEE_REJECTED_CONFIGURATION = -12; // 0xfffffff4

/**
 * Easy Connect Failure event: General protocol failure.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_GENERIC = -7; // 0xfffffff9

/**
 * Easy Connect Failure event: Invalid network provided to Easy Connect configurator.
 * Network must either be WPA3-Personal (SAE) or WPA2-Personal (PSK).
 */

public static final int EASY_CONNECT_EVENT_FAILURE_INVALID_NETWORK = -9; // 0xfffffff7

/**
 * Easy Connect Failure event: Scanned QR code is either not a Easy Connect URI, or the Easy
 * Connect URI has errors.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_INVALID_URI = -1; // 0xffffffff

/**
 * Easy Connect Failure event: Both devices are implementing the same role and are incompatible.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_NOT_COMPATIBLE = -3; // 0xfffffffd

/**
 * Easy Connect Failure event: Feature or option is not supported.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_NOT_SUPPORTED = -8; // 0xfffffff8

/**
 * Easy Connect Failure event: No response from the peer.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_TIMEOUT = -6; // 0xfffffffa

/**
 * Easy Connect Failure event: System failed to generate DPP URI.
 */

public static final int EASY_CONNECT_EVENT_FAILURE_URI_GENERATION = -13; // 0xfffffff3
}

