/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeTrafficSelector represents a Traffic Selector of a Child Session.
 *
 * <p>Traffic Selectors specify addresses that are acceptable within the IPsec SA.
 *
 * <p>Callers can propose {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}s when building a {@link android.net.ipsec.ike.ChildSessionParams ChildSessionParams} and
 * receive the negotiated {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector}s via a {@link android.net.ipsec.ike.ChildSessionConfiguration ChildSessionConfiguration}.
 *
 * @see <a href="https://tools.ietf.org/html/rfc7296#section-3.13">RFC 7296, Internet Key Exchange
 *     Protocol Version 2 (IKEv2)</a>
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeTrafficSelector {

/**
 * Construct an instance of {@link android.net.ipsec.ike.IkeTrafficSelector IkeTrafficSelector} for negotiating a Child Session.
 *
 * <p>Android platform does not support port-based routing. The port range negotiation is only
 * informational.
 *
 * @param startPort the smallest port number allowed by this Traffic Selector.
 * @param endPort the largest port number allowed by this Traffic Selector.
 * @param startingAddress the smallest address included in this Traffic Selector.
 * This value cannot be {@code null}.
 * @param endingAddress the largest address included in this Traffic Selector.

 * This value cannot be {@code null}.
 */

public IkeTrafficSelector(int startPort, int endPort, @android.annotation.NonNull java.net.InetAddress startingAddress, @android.annotation.NonNull java.net.InetAddress endingAddress) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** The largest port number allowed by this Traffic Selector. Informational only. */

public final int endPort;
{ endPort = 0; }

/** The largest address included in this Traffic Selector. */

@android.annotation.NonNull public final java.net.InetAddress endingAddress;
{ endingAddress = null; }

/** The smallest port number allowed by this Traffic Selector. Informational only. */

public final int startPort;
{ startPort = 0; }

/** The smallest address included in this Traffic Selector. */

@android.annotation.NonNull public final java.net.InetAddress startingAddress;
{ startingAddress = null; }
}

