/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media.tv.interactive;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class TvInteractiveAppService extends android.app.Service {

public TvInteractiveAppService() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.os.IBinder onBind(@android.annotation.NonNull android.content.Intent intent) { throw new RuntimeException("Stub!"); }

public void onRegisterAppLinkInfo(@android.annotation.NonNull android.media.tv.interactive.AppLinkInfo appLinkInfo) { throw new RuntimeException("Stub!"); }

public void onUnregisterAppLinkInfo(@android.annotation.NonNull android.media.tv.interactive.AppLinkInfo appLinkInfo) { throw new RuntimeException("Stub!"); }

public void onAppLinkCommand(@android.annotation.NonNull android.os.Bundle command) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.media.tv.interactive.TvInteractiveAppService.Session onCreateSession(@android.annotation.NonNull java.lang.String iAppServiceId, int type);

public final void notifyStateChanged(int type, int state, int error) { throw new RuntimeException("Stub!"); }

public static final java.lang.String COMMAND_PARAMETER_KEY_CHANGE_CHANNEL_QUIETLY = "command_change_channel_quietly";

public static final java.lang.String COMMAND_PARAMETER_KEY_CHANNEL_URI = "command_channel_uri";

public static final java.lang.String COMMAND_PARAMETER_KEY_INPUT_ID = "command_input_id";

public static final java.lang.String COMMAND_PARAMETER_KEY_PLAYBACK_PARAMS = "command_playback_params";

public static final java.lang.String COMMAND_PARAMETER_KEY_PROGRAM_URI = "command_program_uri";

public static final java.lang.String COMMAND_PARAMETER_KEY_STOP_MODE = "command_stop_mode";

public static final java.lang.String COMMAND_PARAMETER_KEY_TIME_POSITION = "command_time_position";

public static final java.lang.String COMMAND_PARAMETER_KEY_TIME_SHIFT_MODE = "command_time_shift_mode";

public static final java.lang.String COMMAND_PARAMETER_KEY_TRACK_ID = "command_track_id";

public static final java.lang.String COMMAND_PARAMETER_KEY_TRACK_TYPE = "command_track_type";

public static final java.lang.String COMMAND_PARAMETER_KEY_VOLUME = "command_volume";

public static final int COMMAND_PARAMETER_VALUE_STOP_MODE_BLANK = 1; // 0x1

public static final int COMMAND_PARAMETER_VALUE_STOP_MODE_FREEZE = 2; // 0x2

public static final java.lang.String PLAYBACK_COMMAND_TYPE_SELECT_TRACK = "select_track";

public static final java.lang.String PLAYBACK_COMMAND_TYPE_SET_STREAM_VOLUME = "set_stream_volume";

public static final java.lang.String PLAYBACK_COMMAND_TYPE_STOP = "stop";

public static final java.lang.String PLAYBACK_COMMAND_TYPE_TUNE = "tune";

public static final java.lang.String PLAYBACK_COMMAND_TYPE_TUNE_NEXT = "tune_next";

public static final java.lang.String PLAYBACK_COMMAND_TYPE_TUNE_PREV = "tune_previous";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String SERVICE_INTERFACE = "android.media.tv.interactive.TvInteractiveAppService";

public static final java.lang.String SERVICE_META_DATA = "android.media.tv.interactive.app";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_PAUSE = "pause";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_PLAY = "play";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_RESUME = "resume";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_SEEK_TO = "seek_to";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_SET_MODE = "set_mode";

public static final java.lang.String TIME_SHIFT_COMMAND_TYPE_SET_PLAYBACK_PARAMS = "set_playback_params";
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Session implements android.view.KeyEvent.Callback {

public Session(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

public void setMediaViewEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public boolean isMediaViewEnabled() { throw new RuntimeException("Stub!"); }

public void onStartInteractiveApp() { throw new RuntimeException("Stub!"); }

public void onStopInteractiveApp() { throw new RuntimeException("Stub!"); }

public void onResetInteractiveApp() { throw new RuntimeException("Stub!"); }

public void onCreateBiInteractiveAppRequest(@android.annotation.NonNull android.net.Uri biIAppUri, @android.annotation.Nullable android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void onDestroyBiInteractiveAppRequest(@android.annotation.NonNull java.lang.String biIAppId) { throw new RuntimeException("Stub!"); }

public void onSetTeletextAppEnabled(boolean enable) { throw new RuntimeException("Stub!"); }

public void onCurrentVideoBounds(@android.annotation.NonNull android.graphics.Rect bounds) { throw new RuntimeException("Stub!"); }

public void onCurrentChannelUri(@android.annotation.Nullable android.net.Uri channelUri) { throw new RuntimeException("Stub!"); }

public void onCurrentChannelLcn(int lcn) { throw new RuntimeException("Stub!"); }

public void onStreamVolume(float volume) { throw new RuntimeException("Stub!"); }

public void onTrackInfoList(@android.annotation.NonNull java.util.List<android.media.tv.TvTrackInfo> tracks) { throw new RuntimeException("Stub!"); }

public void onCurrentTvInputId(@android.annotation.Nullable java.lang.String inputId) { throw new RuntimeException("Stub!"); }

public void onTimeShiftMode(int mode) { throw new RuntimeException("Stub!"); }

public void onAvailableSpeeds(@android.annotation.NonNull float[] speeds) { throw new RuntimeException("Stub!"); }

public void onTvRecordingInfo(@android.annotation.Nullable android.media.tv.TvRecordingInfo recordingInfo) { throw new RuntimeException("Stub!"); }

public void onTvRecordingInfoList(@android.annotation.NonNull java.util.List<android.media.tv.TvRecordingInfo> recordingInfoList) { throw new RuntimeException("Stub!"); }

public void onRecordingStarted(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.Nullable java.lang.String requestId) { throw new RuntimeException("Stub!"); }

public void onRecordingStopped(@android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void onRecordingConnectionFailed(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.NonNull java.lang.String inputId) { throw new RuntimeException("Stub!"); }

public void onRecordingDisconnected(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.NonNull java.lang.String inputId) { throw new RuntimeException("Stub!"); }

public void onRecordingTuned(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.NonNull android.net.Uri channelUri) { throw new RuntimeException("Stub!"); }

public void onRecordingError(@android.annotation.NonNull java.lang.String recordingId, int err) { throw new RuntimeException("Stub!"); }

public void onRecordingScheduled(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.Nullable java.lang.String requestId) { throw new RuntimeException("Stub!"); }

public void onSigningResult(@android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull byte[] result) { throw new RuntimeException("Stub!"); }

public void onError(@android.annotation.NonNull java.lang.String errMsg, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void onTimeShiftPlaybackParams(@android.annotation.NonNull android.media.PlaybackParams params) { throw new RuntimeException("Stub!"); }

public void onTimeShiftStatusChanged(@android.annotation.NonNull java.lang.String inputId, int status) { throw new RuntimeException("Stub!"); }

public void onTimeShiftStartPositionChanged(@android.annotation.NonNull java.lang.String inputId, long timeMs) { throw new RuntimeException("Stub!"); }

public void onTimeShiftCurrentPositionChanged(@android.annotation.NonNull java.lang.String inputId, long timeMs) { throw new RuntimeException("Stub!"); }

public abstract boolean onSetSurface(@android.annotation.Nullable android.view.Surface surface);

public void onSurfaceChanged(int format, int width, int height) { throw new RuntimeException("Stub!"); }

public void onMediaViewSizeChanged(int width, int height) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.view.View onCreateMediaView() { throw new RuntimeException("Stub!"); }

public abstract void onRelease();

public void onTuned(@android.annotation.NonNull android.net.Uri channelUri) { throw new RuntimeException("Stub!"); }

public void onTrackSelected(int type, @android.annotation.NonNull java.lang.String trackId) { throw new RuntimeException("Stub!"); }

public void onTracksChanged(@android.annotation.NonNull java.util.List<android.media.tv.TvTrackInfo> tracks) { throw new RuntimeException("Stub!"); }

public void onVideoAvailable() { throw new RuntimeException("Stub!"); }

public void onVideoUnavailable(int reason) { throw new RuntimeException("Stub!"); }

public void onContentAllowed() { throw new RuntimeException("Stub!"); }

public void onContentBlocked(@android.annotation.NonNull android.media.tv.TvContentRating rating) { throw new RuntimeException("Stub!"); }

public void onSignalStrength(int strength) { throw new RuntimeException("Stub!"); }

public void onBroadcastInfoResponse(@android.annotation.NonNull android.media.tv.BroadcastInfoResponse response) { throw new RuntimeException("Stub!"); }

public void onAdResponse(@android.annotation.NonNull android.media.tv.AdResponse response) { throw new RuntimeException("Stub!"); }

public void onAdBufferConsumed(@android.annotation.NonNull android.media.tv.AdBuffer buffer) { throw new RuntimeException("Stub!"); }

public void onTvMessage(int type, @android.annotation.NonNull android.os.Bundle data) { throw new RuntimeException("Stub!"); }

public boolean onKeyDown(int keyCode, @android.annotation.NonNull android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyLongPress(int keyCode, @android.annotation.NonNull android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyMultiple(int keyCode, int count, @android.annotation.NonNull android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onKeyUp(int keyCode, @android.annotation.NonNull android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }

public boolean onTouchEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onTrackballEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public boolean onGenericMotionEvent(@android.annotation.NonNull android.view.MotionEvent event) { throw new RuntimeException("Stub!"); }

public void layoutSurface(int left, int top, int right, int bottom) { throw new RuntimeException("Stub!"); }

public void requestBroadcastInfo(@android.annotation.NonNull android.media.tv.BroadcastInfoRequest request) { throw new RuntimeException("Stub!"); }

public void removeBroadcastInfo(int requestId) { throw new RuntimeException("Stub!"); }

public void sendPlaybackCommandRequest(@android.annotation.NonNull java.lang.String cmdType, @android.annotation.Nullable android.os.Bundle parameters) { throw new RuntimeException("Stub!"); }

public void sendTimeShiftCommandRequest(@android.annotation.NonNull java.lang.String cmdType, @android.annotation.Nullable android.os.Bundle parameters) { throw new RuntimeException("Stub!"); }

public void setVideoBounds(@android.annotation.NonNull android.graphics.Rect rect) { throw new RuntimeException("Stub!"); }

public void requestCurrentVideoBounds() { throw new RuntimeException("Stub!"); }

public void requestCurrentChannelUri() { throw new RuntimeException("Stub!"); }

public void requestCurrentChannelLcn() { throw new RuntimeException("Stub!"); }

public void requestStreamVolume() { throw new RuntimeException("Stub!"); }

public void requestTrackInfoList() { throw new RuntimeException("Stub!"); }

public void requestCurrentTvInputId() { throw new RuntimeException("Stub!"); }

public void requestTimeShiftMode() { throw new RuntimeException("Stub!"); }

public void requestAvailableSpeeds() { throw new RuntimeException("Stub!"); }

public void requestStartRecording(@android.annotation.NonNull java.lang.String requestId, @android.annotation.Nullable android.net.Uri programUri) { throw new RuntimeException("Stub!"); }

public void requestStopRecording(@android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void requestScheduleRecording(@android.annotation.NonNull java.lang.String requestId, @android.annotation.NonNull java.lang.String inputId, @android.annotation.NonNull android.net.Uri channelUri, @android.annotation.NonNull android.net.Uri programUri, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void requestScheduleRecording(@android.annotation.NonNull java.lang.String requestId, @android.annotation.NonNull java.lang.String inputId, @android.annotation.NonNull android.net.Uri channelUri, long startTime, long duration, int repeatDays, @android.annotation.NonNull android.os.Bundle params) { throw new RuntimeException("Stub!"); }

public void setTvRecordingInfo(@android.annotation.NonNull java.lang.String recordingId, @android.annotation.NonNull android.media.tv.TvRecordingInfo recordingInfo) { throw new RuntimeException("Stub!"); }

public void requestTvRecordingInfo(@android.annotation.NonNull java.lang.String recordingId) { throw new RuntimeException("Stub!"); }

public void requestTvRecordingInfoList(int type) { throw new RuntimeException("Stub!"); }

public void requestSigning(@android.annotation.NonNull java.lang.String signingId, @android.annotation.NonNull java.lang.String algorithm, @android.annotation.NonNull java.lang.String alias, @android.annotation.NonNull byte[] data) { throw new RuntimeException("Stub!"); }

public void requestAd(@android.annotation.NonNull android.media.tv.AdRequest request) { throw new RuntimeException("Stub!"); }

public void notifySessionStateChanged(int state, int err) { throw new RuntimeException("Stub!"); }

public final void notifyBiInteractiveAppCreated(@android.annotation.NonNull android.net.Uri biIAppUri, @android.annotation.Nullable java.lang.String biIAppId) { throw new RuntimeException("Stub!"); }

public final void notifyTeletextAppStateChanged(int state) { throw new RuntimeException("Stub!"); }

public void notifyAdBufferReady(@android.annotation.NonNull android.media.tv.AdBuffer buffer) { throw new RuntimeException("Stub!"); }
}

}

