/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class MediaRoute2ProviderService extends android.app.Service {

public MediaRoute2ProviderService() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.IBinder onBind(@android.annotation.NonNull android.content.Intent intent) { throw new RuntimeException("Stub!"); }

public abstract void onSetRouteVolume(long requestId, @android.annotation.NonNull java.lang.String routeId, int volume);

public abstract void onSetSessionVolume(long requestId, @android.annotation.NonNull java.lang.String sessionId, int volume);

@android.annotation.Nullable
public final android.media.RoutingSessionInfo getSessionInfo(@android.annotation.NonNull java.lang.String sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final java.util.List<android.media.RoutingSessionInfo> getAllSessionInfo() { throw new RuntimeException("Stub!"); }

public final void notifySessionCreated(long requestId, @android.annotation.NonNull android.media.RoutingSessionInfo sessionInfo) { throw new RuntimeException("Stub!"); }

public final void notifySessionUpdated(@android.annotation.NonNull android.media.RoutingSessionInfo sessionInfo) { throw new RuntimeException("Stub!"); }

public final void notifySessionReleased(@android.annotation.NonNull java.lang.String sessionId) { throw new RuntimeException("Stub!"); }

public final void notifyRequestFailed(long requestId, int reason) { throw new RuntimeException("Stub!"); }

public abstract void onCreateSession(long requestId, @android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String routeId, @android.annotation.Nullable android.os.Bundle sessionHints);

public abstract void onReleaseSession(long requestId, @android.annotation.NonNull java.lang.String sessionId);

public abstract void onSelectRoute(long requestId, @android.annotation.NonNull java.lang.String sessionId, @android.annotation.NonNull java.lang.String routeId);

public abstract void onDeselectRoute(long requestId, @android.annotation.NonNull java.lang.String sessionId, @android.annotation.NonNull java.lang.String routeId);

public abstract void onTransferToRoute(long requestId, @android.annotation.NonNull java.lang.String sessionId, @android.annotation.NonNull java.lang.String routeId);

public void onDiscoveryPreferenceChanged(@android.annotation.NonNull android.media.RouteDiscoveryPreference preference) { throw new RuntimeException("Stub!"); }

public final void notifyRoutes(@android.annotation.NonNull java.util.Collection<android.media.MediaRoute2Info> routes) { throw new RuntimeException("Stub!"); }

public static final int REASON_INVALID_COMMAND = 4; // 0x4

public static final int REASON_NETWORK_ERROR = 2; // 0x2

public static final int REASON_REJECTED = 1; // 0x1

public static final int REASON_ROUTE_NOT_AVAILABLE = 3; // 0x3

public static final int REASON_UNKNOWN_ERROR = 0; // 0x0

public static final long REQUEST_ID_NONE = 0L; // 0x0L

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.SERVICE_ACTION) public static final java.lang.String SERVICE_INTERFACE = "android.media.MediaRoute2ProviderService";
}

