/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class LocationRequest implements android.os.Parcelable {

LocationRequest() { throw new RuntimeException("Stub!"); }

public int getQuality() { throw new RuntimeException("Stub!"); }

public long getIntervalMillis() { throw new RuntimeException("Stub!"); }

public long getDurationMillis() { throw new RuntimeException("Stub!"); }

public int getMaxUpdates() { throw new RuntimeException("Stub!"); }

public long getMinUpdateIntervalMillis() { throw new RuntimeException("Stub!"); }

public float getMinUpdateDistanceMeters() { throw new RuntimeException("Stub!"); }

public long getMaxUpdateDelayMillis() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.location.LocationRequest> CREATOR;
static { CREATOR = null; }

public static final long PASSIVE_INTERVAL = 9223372036854775807L; // 0x7fffffffffffffffL

public static final int QUALITY_BALANCED_POWER_ACCURACY = 102; // 0x66

public static final int QUALITY_HIGH_ACCURACY = 100; // 0x64

public static final int QUALITY_LOW_POWER = 104; // 0x68
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(long intervalMillis) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.location.LocationRequest locationRequest) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setIntervalMillis(long intervalMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setQuality(int quality) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setDurationMillis(long durationMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMaxUpdates(int maxUpdates) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMinUpdateIntervalMillis(long minUpdateIntervalMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder clearMinUpdateIntervalMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMinUpdateDistanceMeters(float minUpdateDistanceMeters) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest.Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.location.LocationRequest build() { throw new RuntimeException("Stub!"); }
}

}

