/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import java.util.Set;

/**
 * Captures user sleep session. Each session requires start and end time and a list of {@link android.health.connect.datatypes.SleepSessionRecord.Stage Stage}.
 *
 * <p>Each {@link android.health.connect.datatypes.SleepSessionRecord.Stage Stage} interval should be between the start time and the end time of the session.
 * Stages within one session must not overlap.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SleepSessionRecord extends android.health.connect.datatypes.IntervalRecord {

SleepSessionRecord() { throw new RuntimeException("Stub!"); }

/** Returns notes for the sleep session. Returns null if no notes was specified. */

@android.annotation.Nullable
public java.lang.CharSequence getNotes() { throw new RuntimeException("Stub!"); }

/** Returns title of the sleep session. Returns null if no notes was specified. */

@android.annotation.Nullable
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

/**
 * Returns stages of the sleep session.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.SleepSessionRecord.Stage> getStages() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Metric identifier to retrieve total sleep session duration using aggregate APIs in {@link
 * android.health.connect.HealthConnectManager}. Calculated in milliseconds.
 */

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> SLEEP_DURATION_TOTAL;
static { SLEEP_DURATION_TOTAL = null; }
/** Builder class for {@link android.health.connect.datatypes.SleepSessionRecord SleepSessionRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param startTime Start time of this sleep session
 * This value cannot be {@code null}.
 * @param endTime End time of this sleep session

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity started
 * @param startZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity ended
 * @param endZoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets the start zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * Sets notes for this activity
 *
 * @param notes Additional notes for the session. Optional field.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setNotes(@android.annotation.Nullable java.lang.CharSequence notes) { throw new RuntimeException("Stub!"); }

/**
 * Sets a title of this activity
 *
 * @param title Title of the session. Optional field.
 
 * This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

/**
 * Set stages to this sleep session. Returns Object with updated stages.
 *
 * @param stages list of stages to set
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setStages(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.SleepSessionRecord.Stage> stages) { throw new RuntimeException("Stub!"); }

/**
 * Returns {@link android.health.connect.datatypes.SleepSessionRecord SleepSessionRecord}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord build() { throw new RuntimeException("Stub!"); }
}

/**
 * Captures the user's length and type of sleep. Each record represents a time interval for a
 * stage of sleep.
 *
 * <p>The start time of the record represents the start and end time of the sleep stage and
 * always need to be included.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Stage {

/**
 * Builds {@link android.health.connect.datatypes.SleepSessionRecord.Stage Stage} instance
 *
 * @param startTime start time of the stage
 * This value cannot be {@code null}.
 * @param endTime end time of the stage. Must not be earlier than start time.
 * This value cannot be {@code null}.
 * @param stageType type of the stage. One of {@link android.health.connect.datatypes.SleepSessionRecord.StageType StageType}

 * Value is {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE_OUT_OF_BED}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_LIGHT}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_DEEP}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_REM}, or {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE_IN_BED}
 */

public Stage(@android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, int stageType) { throw new RuntimeException("Stub!"); }

/**
 * Returns start time of this stage.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getStartTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns end time of this stage.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.time.Instant getEndTime() { throw new RuntimeException("Stub!"); }

/**
 * Returns stage type.
 * @return Value is {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_UNKNOWN}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE_OUT_OF_BED}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_LIGHT}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_DEEP}, {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_SLEEPING_REM}, or {@link android.health.connect.datatypes.SleepSessionRecord.StageType#STAGE_TYPE_AWAKE_IN_BED}
 */

public int getType() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

/** Identifier for sleeping stage, as returned by {@link android.health.connect.datatypes.SleepSessionRecord.Stage#getType() Stage#getType()}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StageType {

StageType() { throw new RuntimeException("Stub!"); }

/**
 * The user is awake and either known to be in bed, or it is unknown whether they are in bed
 * or not.
 */

public static final int STAGE_TYPE_AWAKE = 1; // 0x1

/** The user is awake and in bed. */

public static final int STAGE_TYPE_AWAKE_IN_BED = 7; // 0x7

/** The user is out of bed and assumed to be awake. */

public static final int STAGE_TYPE_AWAKE_OUT_OF_BED = 3; // 0x3

/** The user is asleep but the particular stage of sleep (light, deep or REM) is unknown. */

public static final int STAGE_TYPE_SLEEPING = 2; // 0x2

/** The user is in a deep sleep stage. */

public static final int STAGE_TYPE_SLEEPING_DEEP = 5; // 0x5

/** The user is in a light sleep stage. */

public static final int STAGE_TYPE_SLEEPING_LIGHT = 4; // 0x4

/** The user is in a REM sleep stage. */

public static final int STAGE_TYPE_SLEEPING_REM = 6; // 0x6

/** Use this type if the stage of sleep is unknown. */

public static final int STAGE_TYPE_UNKNOWN = 0; // 0x0
}

}

