/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

import android.health.connect.datatypes.units.Percentage;

/**
 * Captures the amount of oxygen circulating in the blood, measured as a percentage of
 * oxygen-saturated hemoglobin. Each record represents a single blood oxygen saturation reading at
 * the time of measurement.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class OxygenSaturationRecord extends android.health.connect.datatypes.InstantRecord {

OxygenSaturationRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return percentage

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.units.Percentage getPercentage() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.OxygenSaturationRecord OxygenSaturationRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param percentage Percentage in {@link android.health.connect.datatypes.units.Percentage Percentage} unit. Required field. Valid range:
 *     0-100.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, @android.annotation.NonNull android.health.connect.datatypes.units.Percentage percentage) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OxygenSaturationRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OxygenSaturationRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.OxygenSaturationRecord OxygenSaturationRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.OxygenSaturationRecord build() { throw new RuntimeException("Stub!"); }
}

}

