/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;


/**
 * Captures the description of cervical mucus. Each record represents a self-assessed description of
 * cervical mucus for a user. All fields are optional and can be used to describe the look and feel
 * of cervical mucus.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CervicalMucusRecord extends android.health.connect.datatypes.InstantRecord {

CervicalMucusRecord() { throw new RuntimeException("Stub!"); }

/**
 * @return sensation

 * Value is {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_UNKNOWN}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_LIGHT}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_MEDIUM}, or {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_HEAVY}
 */

public int getSensation() { throw new RuntimeException("Stub!"); }

/**
 * @return appearance

 * Value is {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_UNKNOWN}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_DRY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_STICKY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_CREAMY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_WATERY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_EGG_WHITE}, or {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_UNUSUAL}
 */

public int getAppearance() { throw new RuntimeException("Stub!"); }

/**
 * Indicates whether some other object is "equal to" this one.
 *
 * @param o the reference object with which to compare.
 * @return {@code true} if this object is the same as the obj
 */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** Returns a hash code value for the object. */

public int hashCode() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.datatypes.CervicalMucusRecord CervicalMucusRecord} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * @param metadata Metadata to be associated with the record. See {@link android.health.connect.datatypes.Metadata Metadata}.
 * This value cannot be {@code null}.
 * @param time Start time of this activity
 * This value cannot be {@code null}.
 * @param sensation The feel of the user's cervical mucus. Optional field. Allowed values:
 *     {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation CervicalMucusSensation}.
 * Value is {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_UNKNOWN}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_LIGHT}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_MEDIUM}, or {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusSensation#SENSATION_HEAVY}
 * @param appearance The consistency of the user's cervical mucus. Optional field. Allowed
 *     values: {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance CervicalMucusAppearance}.

 * Value is {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_UNKNOWN}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_DRY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_STICKY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_CREAMY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_WATERY}, {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_EGG_WHITE}, or {@link android.health.connect.datatypes.CervicalMucusRecord.CervicalMucusAppearance#APPEARANCE_UNUSUAL}
 */

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int sensation, int appearance) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of the user when the activity happened
 * @param zoneOffset This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.CervicalMucusRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }

/**
 * Sets the zone offset of this record to system default.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.CervicalMucusRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

/**
 * @return Object of {@link android.health.connect.datatypes.CervicalMucusRecord CervicalMucusRecord}

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.datatypes.CervicalMucusRecord build() { throw new RuntimeException("Stub!"); }
}

/** Identifier for Cervical Mucus Appearance */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CervicalMucusAppearance {

CervicalMucusAppearance() { throw new RuntimeException("Stub!"); }

/** A constant describing creamy like looking cervical mucus. */

public static final int APPEARANCE_CREAMY = 3; // 0x3

/** A constant describing a dry cervical mucus. */

public static final int APPEARANCE_DRY = 1; // 0x1

/** A constant describing clear or egg white like looking cervical mucus. */

public static final int APPEARANCE_EGG_WHITE = 5; // 0x5

/** A constant describing a sticky cervical mucus. */

public static final int APPEARANCE_STICKY = 2; // 0x2

/** A constant describing cervical mucus which appearance is unknown. */

public static final int APPEARANCE_UNKNOWN = 0; // 0x0

/** A constant describing an unusual (worth attention) kind of cervical mucus. */

public static final int APPEARANCE_UNUSUAL = 6; // 0x6

/** A constant describing watery like looking cervical mucus. */

public static final int APPEARANCE_WATERY = 4; // 0x4
}

/** Identifier for Cervical Mucus Sensation */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class CervicalMucusSensation {

CervicalMucusSensation() { throw new RuntimeException("Stub!"); }

public static final int SENSATION_HEAVY = 3; // 0x3

public static final int SENSATION_LIGHT = 1; // 0x1

public static final int SENSATION_MEDIUM = 2; // 0x2

public static final int SENSATION_UNKNOWN = 0; // 0x0
}

}

