/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

import java.util.concurrent.Executor;
import android.os.OutcomeReceiver;
import android.health.connect.datatypes.Record;
import java.util.List;
import android.health.connect.datatypes.Metadata;

/**
 * A request class to represent request based on id filters with ids for {@link android.health.connect.HealthConnectManager#readRecords(android.health.connect.ReadRecordsRequest,java.util.concurrent.Executor,android.os.OutcomeReceiver)  }
 *
 * @param <T> the type of the Record for the request
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ReadRecordsRequestUsingIds<T extends android.health.connect.datatypes.Record> extends android.health.connect.ReadRecordsRequest<T> {

ReadRecordsRequestUsingIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns List of RecordId
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.health.connect.RecordIdFilter> getRecordIdFilters() { throw new RuntimeException("Stub!"); }
/** Builder class for {@link android.health.connect.ReadRecordsRequestUsingIds ReadRecordsRequestUsingIds} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder<T extends android.health.connect.datatypes.Record> {

/**
 * @param recordType Record class for which the id is being set

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.Class<T> recordType) { throw new RuntimeException("Stub!"); }

/**
 * @param id Identifier generated by the platform and returned by {@link android.health.connect.HealthConnectManager#insertRecords      }
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingIds.Builder<T> addId(@android.annotation.NonNull java.lang.String id) { throw new RuntimeException("Stub!"); }

/**
 * @param clientRecordId identifier that was set while inserting the record
 * This value cannot be {@code null}.
 * @see android.health.connect.datatypes.Metadata
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingIds.Builder<T> addClientRecordId(@android.annotation.NonNull java.lang.String clientRecordId) { throw new RuntimeException("Stub!"); }

/**
 * Returns Object of {@link android.health.connect.ReadRecordsRequestUsingIds ReadRecordsRequestUsingIds}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.health.connect.ReadRecordsRequestUsingIds<T> build() { throw new RuntimeException("Stub!"); }
}

}

