/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class CameraMetadata<TKey> {

CameraMetadata() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<TKey> getKeys() { throw new RuntimeException("Stub!"); }

public static final int AUTOMOTIVE_LENS_FACING_EXTERIOR_FRONT = 1; // 0x1

public static final int AUTOMOTIVE_LENS_FACING_EXTERIOR_LEFT = 3; // 0x3

public static final int AUTOMOTIVE_LENS_FACING_EXTERIOR_OTHER = 0; // 0x0

public static final int AUTOMOTIVE_LENS_FACING_EXTERIOR_REAR = 2; // 0x2

public static final int AUTOMOTIVE_LENS_FACING_EXTERIOR_RIGHT = 4; // 0x4

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_OTHER = 5; // 0x5

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_1_CENTER = 7; // 0x7

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_1_LEFT = 6; // 0x6

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_1_RIGHT = 8; // 0x8

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_2_CENTER = 10; // 0xa

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_2_LEFT = 9; // 0x9

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_2_RIGHT = 11; // 0xb

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_3_CENTER = 13; // 0xd

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_3_LEFT = 12; // 0xc

public static final int AUTOMOTIVE_LENS_FACING_INTERIOR_SEAT_ROW_3_RIGHT = 14; // 0xe

public static final int AUTOMOTIVE_LOCATION_EXTERIOR_FRONT = 2; // 0x2

public static final int AUTOMOTIVE_LOCATION_EXTERIOR_LEFT = 4; // 0x4

public static final int AUTOMOTIVE_LOCATION_EXTERIOR_OTHER = 1; // 0x1

public static final int AUTOMOTIVE_LOCATION_EXTERIOR_REAR = 3; // 0x3

public static final int AUTOMOTIVE_LOCATION_EXTERIOR_RIGHT = 5; // 0x5

public static final int AUTOMOTIVE_LOCATION_EXTRA_FRONT = 7; // 0x7

public static final int AUTOMOTIVE_LOCATION_EXTRA_LEFT = 9; // 0x9

public static final int AUTOMOTIVE_LOCATION_EXTRA_OTHER = 6; // 0x6

public static final int AUTOMOTIVE_LOCATION_EXTRA_REAR = 8; // 0x8

public static final int AUTOMOTIVE_LOCATION_EXTRA_RIGHT = 10; // 0xa

public static final int AUTOMOTIVE_LOCATION_INTERIOR = 0; // 0x0

public static final int COLOR_CORRECTION_ABERRATION_MODE_FAST = 1; // 0x1

public static final int COLOR_CORRECTION_ABERRATION_MODE_HIGH_QUALITY = 2; // 0x2

public static final int COLOR_CORRECTION_ABERRATION_MODE_OFF = 0; // 0x0

public static final int COLOR_CORRECTION_MODE_FAST = 1; // 0x1

public static final int COLOR_CORRECTION_MODE_HIGH_QUALITY = 2; // 0x2

public static final int COLOR_CORRECTION_MODE_TRANSFORM_MATRIX = 0; // 0x0

public static final int CONTROL_AE_ANTIBANDING_MODE_50HZ = 1; // 0x1

public static final int CONTROL_AE_ANTIBANDING_MODE_60HZ = 2; // 0x2

public static final int CONTROL_AE_ANTIBANDING_MODE_AUTO = 3; // 0x3

public static final int CONTROL_AE_ANTIBANDING_MODE_OFF = 0; // 0x0

public static final int CONTROL_AE_MODE_OFF = 0; // 0x0

public static final int CONTROL_AE_MODE_ON = 1; // 0x1

public static final int CONTROL_AE_MODE_ON_ALWAYS_FLASH = 3; // 0x3

public static final int CONTROL_AE_MODE_ON_AUTO_FLASH = 2; // 0x2

public static final int CONTROL_AE_MODE_ON_AUTO_FLASH_REDEYE = 4; // 0x4

public static final int CONTROL_AE_MODE_ON_EXTERNAL_FLASH = 5; // 0x5

public static final int CONTROL_AE_PRECAPTURE_TRIGGER_CANCEL = 2; // 0x2

public static final int CONTROL_AE_PRECAPTURE_TRIGGER_IDLE = 0; // 0x0

public static final int CONTROL_AE_PRECAPTURE_TRIGGER_START = 1; // 0x1

public static final int CONTROL_AE_STATE_CONVERGED = 2; // 0x2

public static final int CONTROL_AE_STATE_FLASH_REQUIRED = 4; // 0x4

public static final int CONTROL_AE_STATE_INACTIVE = 0; // 0x0

public static final int CONTROL_AE_STATE_LOCKED = 3; // 0x3

public static final int CONTROL_AE_STATE_PRECAPTURE = 5; // 0x5

public static final int CONTROL_AE_STATE_SEARCHING = 1; // 0x1

public static final int CONTROL_AF_MODE_AUTO = 1; // 0x1

public static final int CONTROL_AF_MODE_CONTINUOUS_PICTURE = 4; // 0x4

public static final int CONTROL_AF_MODE_CONTINUOUS_VIDEO = 3; // 0x3

public static final int CONTROL_AF_MODE_EDOF = 5; // 0x5

public static final int CONTROL_AF_MODE_MACRO = 2; // 0x2

public static final int CONTROL_AF_MODE_OFF = 0; // 0x0

public static final int CONTROL_AF_SCENE_CHANGE_DETECTED = 1; // 0x1

public static final int CONTROL_AF_SCENE_CHANGE_NOT_DETECTED = 0; // 0x0

public static final int CONTROL_AF_STATE_ACTIVE_SCAN = 3; // 0x3

public static final int CONTROL_AF_STATE_FOCUSED_LOCKED = 4; // 0x4

public static final int CONTROL_AF_STATE_INACTIVE = 0; // 0x0

public static final int CONTROL_AF_STATE_NOT_FOCUSED_LOCKED = 5; // 0x5

public static final int CONTROL_AF_STATE_PASSIVE_FOCUSED = 2; // 0x2

public static final int CONTROL_AF_STATE_PASSIVE_SCAN = 1; // 0x1

public static final int CONTROL_AF_STATE_PASSIVE_UNFOCUSED = 6; // 0x6

public static final int CONTROL_AF_TRIGGER_CANCEL = 2; // 0x2

public static final int CONTROL_AF_TRIGGER_IDLE = 0; // 0x0

public static final int CONTROL_AF_TRIGGER_START = 1; // 0x1

public static final int CONTROL_AUTOFRAMING_OFF = 0; // 0x0

public static final int CONTROL_AUTOFRAMING_ON = 1; // 0x1

public static final int CONTROL_AUTOFRAMING_STATE_CONVERGED = 2; // 0x2

public static final int CONTROL_AUTOFRAMING_STATE_FRAMING = 1; // 0x1

public static final int CONTROL_AUTOFRAMING_STATE_INACTIVE = 0; // 0x0

public static final int CONTROL_AWB_MODE_AUTO = 1; // 0x1

public static final int CONTROL_AWB_MODE_CLOUDY_DAYLIGHT = 6; // 0x6

public static final int CONTROL_AWB_MODE_DAYLIGHT = 5; // 0x5

public static final int CONTROL_AWB_MODE_FLUORESCENT = 3; // 0x3

public static final int CONTROL_AWB_MODE_INCANDESCENT = 2; // 0x2

public static final int CONTROL_AWB_MODE_OFF = 0; // 0x0

public static final int CONTROL_AWB_MODE_SHADE = 8; // 0x8

public static final int CONTROL_AWB_MODE_TWILIGHT = 7; // 0x7

public static final int CONTROL_AWB_MODE_WARM_FLUORESCENT = 4; // 0x4

public static final int CONTROL_AWB_STATE_CONVERGED = 2; // 0x2

public static final int CONTROL_AWB_STATE_INACTIVE = 0; // 0x0

public static final int CONTROL_AWB_STATE_LOCKED = 3; // 0x3

public static final int CONTROL_AWB_STATE_SEARCHING = 1; // 0x1

public static final int CONTROL_CAPTURE_INTENT_CUSTOM = 0; // 0x0

public static final int CONTROL_CAPTURE_INTENT_MANUAL = 6; // 0x6

public static final int CONTROL_CAPTURE_INTENT_MOTION_TRACKING = 7; // 0x7

public static final int CONTROL_CAPTURE_INTENT_PREVIEW = 1; // 0x1

public static final int CONTROL_CAPTURE_INTENT_STILL_CAPTURE = 2; // 0x2

public static final int CONTROL_CAPTURE_INTENT_VIDEO_RECORD = 3; // 0x3

public static final int CONTROL_CAPTURE_INTENT_VIDEO_SNAPSHOT = 4; // 0x4

public static final int CONTROL_CAPTURE_INTENT_ZERO_SHUTTER_LAG = 5; // 0x5

public static final int CONTROL_EFFECT_MODE_AQUA = 8; // 0x8

public static final int CONTROL_EFFECT_MODE_BLACKBOARD = 7; // 0x7

public static final int CONTROL_EFFECT_MODE_MONO = 1; // 0x1

public static final int CONTROL_EFFECT_MODE_NEGATIVE = 2; // 0x2

public static final int CONTROL_EFFECT_MODE_OFF = 0; // 0x0

public static final int CONTROL_EFFECT_MODE_POSTERIZE = 5; // 0x5

public static final int CONTROL_EFFECT_MODE_SEPIA = 4; // 0x4

public static final int CONTROL_EFFECT_MODE_SOLARIZE = 3; // 0x3

public static final int CONTROL_EFFECT_MODE_WHITEBOARD = 6; // 0x6

public static final int CONTROL_EXTENDED_SCENE_MODE_BOKEH_CONTINUOUS = 2; // 0x2

public static final int CONTROL_EXTENDED_SCENE_MODE_BOKEH_STILL_CAPTURE = 1; // 0x1

public static final int CONTROL_EXTENDED_SCENE_MODE_DISABLED = 0; // 0x0

public static final int CONTROL_MODE_AUTO = 1; // 0x1

public static final int CONTROL_MODE_OFF = 0; // 0x0

public static final int CONTROL_MODE_OFF_KEEP_STATE = 3; // 0x3

public static final int CONTROL_MODE_USE_EXTENDED_SCENE_MODE = 4; // 0x4

public static final int CONTROL_MODE_USE_SCENE_MODE = 2; // 0x2

public static final int CONTROL_SCENE_MODE_ACTION = 2; // 0x2

public static final int CONTROL_SCENE_MODE_BARCODE = 16; // 0x10

public static final int CONTROL_SCENE_MODE_BEACH = 8; // 0x8

public static final int CONTROL_SCENE_MODE_CANDLELIGHT = 15; // 0xf

public static final int CONTROL_SCENE_MODE_DISABLED = 0; // 0x0

public static final int CONTROL_SCENE_MODE_FACE_PRIORITY = 1; // 0x1

public static final int CONTROL_SCENE_MODE_FIREWORKS = 12; // 0xc

public static final int CONTROL_SCENE_MODE_HDR = 18; // 0x12

@Deprecated public static final int CONTROL_SCENE_MODE_HIGH_SPEED_VIDEO = 17; // 0x11

public static final int CONTROL_SCENE_MODE_LANDSCAPE = 4; // 0x4

public static final int CONTROL_SCENE_MODE_NIGHT = 5; // 0x5

public static final int CONTROL_SCENE_MODE_NIGHT_PORTRAIT = 6; // 0x6

public static final int CONTROL_SCENE_MODE_PARTY = 14; // 0xe

public static final int CONTROL_SCENE_MODE_PORTRAIT = 3; // 0x3

public static final int CONTROL_SCENE_MODE_SNOW = 9; // 0x9

public static final int CONTROL_SCENE_MODE_SPORTS = 13; // 0xd

public static final int CONTROL_SCENE_MODE_STEADYPHOTO = 11; // 0xb

public static final int CONTROL_SCENE_MODE_SUNSET = 10; // 0xa

public static final int CONTROL_SCENE_MODE_THEATRE = 7; // 0x7

public static final int CONTROL_SETTINGS_OVERRIDE_OFF = 0; // 0x0

public static final int CONTROL_SETTINGS_OVERRIDE_ZOOM = 1; // 0x1

public static final int CONTROL_VIDEO_STABILIZATION_MODE_OFF = 0; // 0x0

public static final int CONTROL_VIDEO_STABILIZATION_MODE_ON = 1; // 0x1

public static final int CONTROL_VIDEO_STABILIZATION_MODE_PREVIEW_STABILIZATION = 2; // 0x2

public static final int DISTORTION_CORRECTION_MODE_FAST = 1; // 0x1

public static final int DISTORTION_CORRECTION_MODE_HIGH_QUALITY = 2; // 0x2

public static final int DISTORTION_CORRECTION_MODE_OFF = 0; // 0x0

public static final int EDGE_MODE_FAST = 1; // 0x1

public static final int EDGE_MODE_HIGH_QUALITY = 2; // 0x2

public static final int EDGE_MODE_OFF = 0; // 0x0

public static final int EDGE_MODE_ZERO_SHUTTER_LAG = 3; // 0x3

public static final int FLASH_MODE_OFF = 0; // 0x0

public static final int FLASH_MODE_SINGLE = 1; // 0x1

public static final int FLASH_MODE_TORCH = 2; // 0x2

public static final int FLASH_STATE_CHARGING = 1; // 0x1

public static final int FLASH_STATE_FIRED = 3; // 0x3

public static final int FLASH_STATE_PARTIAL = 4; // 0x4

public static final int FLASH_STATE_READY = 2; // 0x2

public static final int FLASH_STATE_UNAVAILABLE = 0; // 0x0

public static final int HOT_PIXEL_MODE_FAST = 1; // 0x1

public static final int HOT_PIXEL_MODE_HIGH_QUALITY = 2; // 0x2

public static final int HOT_PIXEL_MODE_OFF = 0; // 0x0

public static final int INFO_SUPPORTED_HARDWARE_LEVEL_3 = 3; // 0x3

public static final int INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL = 4; // 0x4

public static final int INFO_SUPPORTED_HARDWARE_LEVEL_FULL = 1; // 0x1

public static final int INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY = 2; // 0x2

public static final int INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED = 0; // 0x0

public static final int LENS_FACING_BACK = 1; // 0x1

public static final int LENS_FACING_EXTERNAL = 2; // 0x2

public static final int LENS_FACING_FRONT = 0; // 0x0

public static final int LENS_INFO_FOCUS_DISTANCE_CALIBRATION_APPROXIMATE = 1; // 0x1

public static final int LENS_INFO_FOCUS_DISTANCE_CALIBRATION_CALIBRATED = 2; // 0x2

public static final int LENS_INFO_FOCUS_DISTANCE_CALIBRATION_UNCALIBRATED = 0; // 0x0

public static final int LENS_OPTICAL_STABILIZATION_MODE_OFF = 0; // 0x0

public static final int LENS_OPTICAL_STABILIZATION_MODE_ON = 1; // 0x1

public static final int LENS_POSE_REFERENCE_AUTOMOTIVE = 3; // 0x3

public static final int LENS_POSE_REFERENCE_GYROSCOPE = 1; // 0x1

public static final int LENS_POSE_REFERENCE_PRIMARY_CAMERA = 0; // 0x0

public static final int LENS_POSE_REFERENCE_UNDEFINED = 2; // 0x2

public static final int LENS_STATE_MOVING = 1; // 0x1

public static final int LENS_STATE_STATIONARY = 0; // 0x0

public static final int LOGICAL_MULTI_CAMERA_SENSOR_SYNC_TYPE_APPROXIMATE = 0; // 0x0

public static final int LOGICAL_MULTI_CAMERA_SENSOR_SYNC_TYPE_CALIBRATED = 1; // 0x1

public static final int NOISE_REDUCTION_MODE_FAST = 1; // 0x1

public static final int NOISE_REDUCTION_MODE_HIGH_QUALITY = 2; // 0x2

public static final int NOISE_REDUCTION_MODE_MINIMAL = 3; // 0x3

public static final int NOISE_REDUCTION_MODE_OFF = 0; // 0x0

public static final int NOISE_REDUCTION_MODE_ZERO_SHUTTER_LAG = 4; // 0x4

public static final int REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE = 0; // 0x0

public static final int REQUEST_AVAILABLE_CAPABILITIES_BURST_CAPTURE = 6; // 0x6

public static final int REQUEST_AVAILABLE_CAPABILITIES_COLOR_SPACE_PROFILES = 20; // 0x14

public static final int REQUEST_AVAILABLE_CAPABILITIES_CONSTRAINED_HIGH_SPEED_VIDEO = 9; // 0x9

public static final int REQUEST_AVAILABLE_CAPABILITIES_DEPTH_OUTPUT = 8; // 0x8

public static final int REQUEST_AVAILABLE_CAPABILITIES_DYNAMIC_RANGE_TEN_BIT = 18; // 0x12

public static final int REQUEST_AVAILABLE_CAPABILITIES_LOGICAL_MULTI_CAMERA = 11; // 0xb

public static final int REQUEST_AVAILABLE_CAPABILITIES_MANUAL_POST_PROCESSING = 2; // 0x2

public static final int REQUEST_AVAILABLE_CAPABILITIES_MANUAL_SENSOR = 1; // 0x1

public static final int REQUEST_AVAILABLE_CAPABILITIES_MONOCHROME = 12; // 0xc

public static final int REQUEST_AVAILABLE_CAPABILITIES_MOTION_TRACKING = 10; // 0xa

public static final int REQUEST_AVAILABLE_CAPABILITIES_OFFLINE_PROCESSING = 15; // 0xf

public static final int REQUEST_AVAILABLE_CAPABILITIES_PRIVATE_REPROCESSING = 4; // 0x4

public static final int REQUEST_AVAILABLE_CAPABILITIES_RAW = 3; // 0x3

public static final int REQUEST_AVAILABLE_CAPABILITIES_READ_SENSOR_SETTINGS = 5; // 0x5

public static final int REQUEST_AVAILABLE_CAPABILITIES_REMOSAIC_REPROCESSING = 17; // 0x11

public static final int REQUEST_AVAILABLE_CAPABILITIES_SECURE_IMAGE_DATA = 13; // 0xd

public static final int REQUEST_AVAILABLE_CAPABILITIES_STREAM_USE_CASE = 19; // 0x13

public static final int REQUEST_AVAILABLE_CAPABILITIES_SYSTEM_CAMERA = 14; // 0xe

public static final int REQUEST_AVAILABLE_CAPABILITIES_ULTRA_HIGH_RESOLUTION_SENSOR = 16; // 0x10

public static final int REQUEST_AVAILABLE_CAPABILITIES_YUV_REPROCESSING = 7; // 0x7

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_CROPPED_RAW = 6; // 0x6

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_DEFAULT = 0; // 0x0

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_PREVIEW = 1; // 0x1

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_PREVIEW_VIDEO_STILL = 4; // 0x4

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_STILL_CAPTURE = 2; // 0x2

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_VIDEO_CALL = 5; // 0x5

public static final int SCALER_AVAILABLE_STREAM_USE_CASES_VIDEO_RECORD = 3; // 0x3

public static final int SCALER_CROPPING_TYPE_CENTER_ONLY = 0; // 0x0

public static final int SCALER_CROPPING_TYPE_FREEFORM = 1; // 0x1

public static final int SCALER_ROTATE_AND_CROP_180 = 2; // 0x2

public static final int SCALER_ROTATE_AND_CROP_270 = 3; // 0x3

public static final int SCALER_ROTATE_AND_CROP_90 = 1; // 0x1

public static final int SCALER_ROTATE_AND_CROP_AUTO = 4; // 0x4

public static final int SCALER_ROTATE_AND_CROP_NONE = 0; // 0x0

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_BGGR = 3; // 0x3

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GBRG = 2; // 0x2

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GRBG = 1; // 0x1

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_MONO = 5; // 0x5

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_NIR = 6; // 0x6

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGB = 4; // 0x4

public static final int SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGGB = 0; // 0x0

public static final int SENSOR_INFO_TIMESTAMP_SOURCE_REALTIME = 1; // 0x1

public static final int SENSOR_INFO_TIMESTAMP_SOURCE_UNKNOWN = 0; // 0x0

public static final int SENSOR_PIXEL_MODE_DEFAULT = 0; // 0x0

public static final int SENSOR_PIXEL_MODE_MAXIMUM_RESOLUTION = 1; // 0x1

public static final int SENSOR_READOUT_TIMESTAMP_HARDWARE = 1; // 0x1

public static final int SENSOR_READOUT_TIMESTAMP_NOT_SUPPORTED = 0; // 0x0

public static final int SENSOR_REFERENCE_ILLUMINANT1_CLOUDY_WEATHER = 10; // 0xa

public static final int SENSOR_REFERENCE_ILLUMINANT1_COOL_WHITE_FLUORESCENT = 14; // 0xe

public static final int SENSOR_REFERENCE_ILLUMINANT1_D50 = 23; // 0x17

public static final int SENSOR_REFERENCE_ILLUMINANT1_D55 = 20; // 0x14

public static final int SENSOR_REFERENCE_ILLUMINANT1_D65 = 21; // 0x15

public static final int SENSOR_REFERENCE_ILLUMINANT1_D75 = 22; // 0x16

public static final int SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT = 1; // 0x1

public static final int SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT_FLUORESCENT = 12; // 0xc

public static final int SENSOR_REFERENCE_ILLUMINANT1_DAY_WHITE_FLUORESCENT = 13; // 0xd

public static final int SENSOR_REFERENCE_ILLUMINANT1_FINE_WEATHER = 9; // 0x9

public static final int SENSOR_REFERENCE_ILLUMINANT1_FLASH = 4; // 0x4

public static final int SENSOR_REFERENCE_ILLUMINANT1_FLUORESCENT = 2; // 0x2

public static final int SENSOR_REFERENCE_ILLUMINANT1_ISO_STUDIO_TUNGSTEN = 24; // 0x18

public static final int SENSOR_REFERENCE_ILLUMINANT1_SHADE = 11; // 0xb

public static final int SENSOR_REFERENCE_ILLUMINANT1_STANDARD_A = 17; // 0x11

public static final int SENSOR_REFERENCE_ILLUMINANT1_STANDARD_B = 18; // 0x12

public static final int SENSOR_REFERENCE_ILLUMINANT1_STANDARD_C = 19; // 0x13

public static final int SENSOR_REFERENCE_ILLUMINANT1_TUNGSTEN = 3; // 0x3

public static final int SENSOR_REFERENCE_ILLUMINANT1_WHITE_FLUORESCENT = 15; // 0xf

public static final int SENSOR_TEST_PATTERN_MODE_COLOR_BARS = 2; // 0x2

public static final int SENSOR_TEST_PATTERN_MODE_COLOR_BARS_FADE_TO_GRAY = 3; // 0x3

public static final int SENSOR_TEST_PATTERN_MODE_CUSTOM1 = 256; // 0x100

public static final int SENSOR_TEST_PATTERN_MODE_OFF = 0; // 0x0

public static final int SENSOR_TEST_PATTERN_MODE_PN9 = 4; // 0x4

public static final int SENSOR_TEST_PATTERN_MODE_SOLID_COLOR = 1; // 0x1

public static final int SHADING_MODE_FAST = 1; // 0x1

public static final int SHADING_MODE_HIGH_QUALITY = 2; // 0x2

public static final int SHADING_MODE_OFF = 0; // 0x0

public static final int STATISTICS_FACE_DETECT_MODE_FULL = 2; // 0x2

public static final int STATISTICS_FACE_DETECT_MODE_OFF = 0; // 0x0

public static final int STATISTICS_FACE_DETECT_MODE_SIMPLE = 1; // 0x1

public static final int STATISTICS_LENS_SHADING_MAP_MODE_OFF = 0; // 0x0

public static final int STATISTICS_LENS_SHADING_MAP_MODE_ON = 1; // 0x1

public static final int STATISTICS_OIS_DATA_MODE_OFF = 0; // 0x0

public static final int STATISTICS_OIS_DATA_MODE_ON = 1; // 0x1

public static final int STATISTICS_SCENE_FLICKER_50HZ = 1; // 0x1

public static final int STATISTICS_SCENE_FLICKER_60HZ = 2; // 0x2

public static final int STATISTICS_SCENE_FLICKER_NONE = 0; // 0x0

public static final int SYNC_MAX_LATENCY_PER_FRAME_CONTROL = 0; // 0x0

public static final int SYNC_MAX_LATENCY_UNKNOWN = -1; // 0xffffffff

public static final int TONEMAP_MODE_CONTRAST_CURVE = 0; // 0x0

public static final int TONEMAP_MODE_FAST = 1; // 0x1

public static final int TONEMAP_MODE_GAMMA_VALUE = 3; // 0x3

public static final int TONEMAP_MODE_HIGH_QUALITY = 2; // 0x2

public static final int TONEMAP_MODE_PRESET_CURVE = 4; // 0x4

public static final int TONEMAP_PRESET_CURVE_REC709 = 1; // 0x1

public static final int TONEMAP_PRESET_CURVE_SRGB = 0; // 0x0
}

