/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CameraExtensionCharacteristics {

CameraExtensionCharacteristics() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedExtensions() { throw new RuntimeException("Stub!"); }

public boolean isPostviewAvailable(int extension) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.util.Size> getPostviewSupportedSizes(int extension, @android.annotation.NonNull android.util.Size captureSize, int format) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public <T> java.util.List<android.util.Size> getExtensionSupportedSizes(int extension, @android.annotation.NonNull java.lang.Class<T> klass) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.util.Size> getExtensionSupportedSizes(int extension, int format) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.util.Range<java.lang.Long> getEstimatedCaptureLatencyRangeMillis(int extension, @android.annotation.NonNull android.util.Size captureOutputSize, int format) { throw new RuntimeException("Stub!"); }

public boolean isCaptureProcessProgressAvailable(int extension) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<android.hardware.camera2.CaptureRequest.Key> getAvailableCaptureRequestKeys(int extension) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<android.hardware.camera2.CaptureResult.Key> getAvailableCaptureResultKeys(int extension) { throw new RuntimeException("Stub!"); }

public static final int EXTENSION_AUTOMATIC = 0; // 0x0

@Deprecated public static final int EXTENSION_BEAUTY = 1; // 0x1

public static final int EXTENSION_BOKEH = 2; // 0x2

public static final int EXTENSION_FACE_RETOUCH = 1; // 0x1

public static final int EXTENSION_HDR = 3; // 0x3

public static final int EXTENSION_NIGHT = 4; // 0x4
}

