/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware.camera2;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CameraCharacteristics extends android.hardware.camera2.CameraMetadata<android.hardware.camera2.CameraCharacteristics.Key<?>> {

CameraCharacteristics() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public <T> T get(android.hardware.camera2.CameraCharacteristics.Key<T> key) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.hardware.camera2.CameraCharacteristics.Key<?>> getKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.hardware.camera2.CameraCharacteristics.Key<?>> getKeysNeedingPermission() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.hardware.camera2.params.RecommendedStreamConfigurationMap getRecommendedStreamConfigurationMap(int usecase) { throw new RuntimeException("Stub!"); }

public java.util.List<android.hardware.camera2.CaptureRequest.Key<?>> getAvailableSessionKeys() { throw new RuntimeException("Stub!"); }

public java.util.List<android.hardware.camera2.CaptureRequest.Key<?>> getAvailablePhysicalCameraRequestKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.hardware.camera2.CaptureRequest.Key<?>> getAvailableCaptureRequestKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.hardware.camera2.CaptureResult.Key<?>> getAvailableCaptureResultKeys() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getPhysicalCameraIds() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> AUTOMOTIVE_LENS_FACING;
static { AUTOMOTIVE_LENS_FACING = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> AUTOMOTIVE_LOCATION;
static { AUTOMOTIVE_LOCATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES;
static { COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AE_AVAILABLE_ANTIBANDING_MODES;
static { CONTROL_AE_AVAILABLE_ANTIBANDING_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AE_AVAILABLE_MODES;
static { CONTROL_AE_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Integer>[]> CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES;
static { CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Integer>> CONTROL_AE_COMPENSATION_RANGE;
static { CONTROL_AE_COMPENSATION_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Rational> CONTROL_AE_COMPENSATION_STEP;
static { CONTROL_AE_COMPENSATION_STEP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> CONTROL_AE_LOCK_AVAILABLE;
static { CONTROL_AE_LOCK_AVAILABLE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AF_AVAILABLE_MODES;
static { CONTROL_AF_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> CONTROL_AUTOFRAMING_AVAILABLE;
static { CONTROL_AUTOFRAMING_AVAILABLE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AVAILABLE_EFFECTS;
static { CONTROL_AVAILABLE_EFFECTS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.Capability[]> CONTROL_AVAILABLE_EXTENDED_SCENE_MODE_CAPABILITIES;
static { CONTROL_AVAILABLE_EXTENDED_SCENE_MODE_CAPABILITIES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AVAILABLE_MODES;
static { CONTROL_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AVAILABLE_SCENE_MODES;
static { CONTROL_AVAILABLE_SCENE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AVAILABLE_SETTINGS_OVERRIDES;
static { CONTROL_AVAILABLE_SETTINGS_OVERRIDES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES;
static { CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> CONTROL_AWB_AVAILABLE_MODES;
static { CONTROL_AWB_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> CONTROL_AWB_LOCK_AVAILABLE;
static { CONTROL_AWB_LOCK_AVAILABLE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> CONTROL_MAX_REGIONS_AE;
static { CONTROL_MAX_REGIONS_AE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> CONTROL_MAX_REGIONS_AF;
static { CONTROL_MAX_REGIONS_AF = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> CONTROL_MAX_REGIONS_AWB;
static { CONTROL_MAX_REGIONS_AWB = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Integer>> CONTROL_POST_RAW_SENSITIVITY_BOOST_RANGE;
static { CONTROL_POST_RAW_SENSITIVITY_BOOST_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Float>> CONTROL_ZOOM_RATIO_RANGE;
static { CONTROL_ZOOM_RATIO_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> DEPTH_DEPTH_IS_EXCLUSIVE;
static { DEPTH_DEPTH_IS_EXCLUSIVE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> DISTORTION_CORRECTION_AVAILABLE_MODES;
static { DISTORTION_CORRECTION_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> EDGE_AVAILABLE_EDGE_MODES;
static { EDGE_AVAILABLE_EDGE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> FLASH_INFO_AVAILABLE;
static { FLASH_INFO_AVAILABLE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> FLASH_INFO_STRENGTH_DEFAULT_LEVEL;
static { FLASH_INFO_STRENGTH_DEFAULT_LEVEL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> FLASH_INFO_STRENGTH_MAXIMUM_LEVEL;
static { FLASH_INFO_STRENGTH_MAXIMUM_LEVEL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES;
static { HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.DeviceStateSensorOrientationMap> INFO_DEVICE_STATE_SENSOR_ORIENTATION_MAP;
static { INFO_DEVICE_STATE_SENSOR_ORIENTATION_MAP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> INFO_SUPPORTED_HARDWARE_LEVEL;
static { INFO_SUPPORTED_HARDWARE_LEVEL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.String> INFO_VERSION;
static { INFO_VERSION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Size[]> JPEG_AVAILABLE_THUMBNAIL_SIZES;
static { JPEG_AVAILABLE_THUMBNAIL_SIZES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_DISTORTION;
static { LENS_DISTORTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_DISTORTION_MAXIMUM_RESOLUTION;
static { LENS_DISTORTION_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> LENS_FACING;
static { LENS_FACING = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_INFO_AVAILABLE_APERTURES;
static { LENS_INFO_AVAILABLE_APERTURES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_INFO_AVAILABLE_FILTER_DENSITIES;
static { LENS_INFO_AVAILABLE_FILTER_DENSITIES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_INFO_AVAILABLE_FOCAL_LENGTHS;
static { LENS_INFO_AVAILABLE_FOCAL_LENGTHS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION;
static { LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> LENS_INFO_FOCUS_DISTANCE_CALIBRATION;
static { LENS_INFO_FOCUS_DISTANCE_CALIBRATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Float> LENS_INFO_HYPERFOCAL_DISTANCE;
static { LENS_INFO_HYPERFOCAL_DISTANCE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Float> LENS_INFO_MINIMUM_FOCUS_DISTANCE;
static { LENS_INFO_MINIMUM_FOCUS_DISTANCE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_INTRINSIC_CALIBRATION;
static { LENS_INTRINSIC_CALIBRATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_INTRINSIC_CALIBRATION_MAXIMUM_RESOLUTION;
static { LENS_INTRINSIC_CALIBRATION_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> LENS_POSE_REFERENCE;
static { LENS_POSE_REFERENCE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_POSE_ROTATION;
static { LENS_POSE_ROTATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_POSE_TRANSLATION;
static { LENS_POSE_TRANSLATION = null; }

@Deprecated @android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<float[]> LENS_RADIAL_DISTORTION;
static { LENS_RADIAL_DISTORTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> LOGICAL_MULTI_CAMERA_SENSOR_SYNC_TYPE;
static { LOGICAL_MULTI_CAMERA_SENSOR_SYNC_TYPE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES;
static { NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REPROCESS_MAX_CAPTURE_STALL;
static { REPROCESS_MAX_CAPTURE_STALL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> REQUEST_AVAILABLE_CAPABILITIES;
static { REQUEST_AVAILABLE_CAPABILITIES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceProfiles> REQUEST_AVAILABLE_COLOR_SPACE_PROFILES;
static { REQUEST_AVAILABLE_COLOR_SPACE_PROFILES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.DynamicRangeProfiles> REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES;
static { REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REQUEST_MAX_NUM_INPUT_STREAMS;
static { REQUEST_MAX_NUM_INPUT_STREAMS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REQUEST_MAX_NUM_OUTPUT_PROC;
static { REQUEST_MAX_NUM_OUTPUT_PROC = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REQUEST_MAX_NUM_OUTPUT_PROC_STALLING;
static { REQUEST_MAX_NUM_OUTPUT_PROC_STALLING = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REQUEST_MAX_NUM_OUTPUT_RAW;
static { REQUEST_MAX_NUM_OUTPUT_RAW = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> REQUEST_PARTIAL_RESULT_COUNT;
static { REQUEST_PARTIAL_RESULT_COUNT = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Byte> REQUEST_PIPELINE_MAX_DEPTH;
static { REQUEST_PIPELINE_MAX_DEPTH = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Long> REQUEST_RECOMMENDED_TEN_BIT_DYNAMIC_RANGE_PROFILE;
static { REQUEST_RECOMMENDED_TEN_BIT_DYNAMIC_RANGE_PROFILE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Float> SCALER_AVAILABLE_MAX_DIGITAL_ZOOM;
static { SCALER_AVAILABLE_MAX_DIGITAL_ZOOM = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> SCALER_AVAILABLE_ROTATE_AND_CROP_MODES;
static { SCALER_AVAILABLE_ROTATE_AND_CROP_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<long[]> SCALER_AVAILABLE_STREAM_USE_CASES;
static { SCALER_AVAILABLE_STREAM_USE_CASES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SCALER_CROPPING_TYPE;
static { SCALER_CROPPING_TYPE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Size> SCALER_DEFAULT_SECURE_IMAGE_SIZE;
static { SCALER_DEFAULT_SECURE_IMAGE_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_CONCURRENT_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_CONCURRENT_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_MAXIMUM_RESOLUTION_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_MAXIMUM_RESOLUTION_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_PREVIEW_STABILIZATION_OUTPUT_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_PREVIEW_STABILIZATION_OUTPUT_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_TEN_BIT_OUTPUT_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_TEN_BIT_OUTPUT_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MandatoryStreamCombination[]> SCALER_MANDATORY_USE_CASE_STREAM_COMBINATIONS;
static { SCALER_MANDATORY_USE_CASE_STREAM_COMBINATIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.MultiResolutionStreamConfigurationMap> SCALER_MULTI_RESOLUTION_STREAM_CONFIGURATION_MAP;
static { SCALER_MULTI_RESOLUTION_STREAM_CONFIGURATION_MAP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.StreamConfigurationMap> SCALER_STREAM_CONFIGURATION_MAP;
static { SCALER_STREAM_CONFIGURATION_MAP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.StreamConfigurationMap> SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION;
static { SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> SENSOR_AVAILABLE_TEST_PATTERN_MODES;
static { SENSOR_AVAILABLE_TEST_PATTERN_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.BlackLevelPattern> SENSOR_BLACK_LEVEL_PATTERN;
static { SENSOR_BLACK_LEVEL_PATTERN = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_CALIBRATION_TRANSFORM1;
static { SENSOR_CALIBRATION_TRANSFORM1 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_CALIBRATION_TRANSFORM2;
static { SENSOR_CALIBRATION_TRANSFORM2 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_COLOR_TRANSFORM1;
static { SENSOR_COLOR_TRANSFORM1 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_COLOR_TRANSFORM2;
static { SENSOR_COLOR_TRANSFORM2 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_FORWARD_MATRIX1;
static { SENSOR_FORWARD_MATRIX1 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.hardware.camera2.params.ColorSpaceTransform> SENSOR_FORWARD_MATRIX2;
static { SENSOR_FORWARD_MATRIX2 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.graphics.Rect> SENSOR_INFO_ACTIVE_ARRAY_SIZE;
static { SENSOR_INFO_ACTIVE_ARRAY_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.graphics.Rect> SENSOR_INFO_ACTIVE_ARRAY_SIZE_MAXIMUM_RESOLUTION;
static { SENSOR_INFO_ACTIVE_ARRAY_SIZE_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Size> SENSOR_INFO_BINNING_FACTOR;
static { SENSOR_INFO_BINNING_FACTOR = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_INFO_COLOR_FILTER_ARRANGEMENT;
static { SENSOR_INFO_COLOR_FILTER_ARRANGEMENT = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Long>> SENSOR_INFO_EXPOSURE_TIME_RANGE;
static { SENSOR_INFO_EXPOSURE_TIME_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Boolean> SENSOR_INFO_LENS_SHADING_APPLIED;
static { SENSOR_INFO_LENS_SHADING_APPLIED = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Long> SENSOR_INFO_MAX_FRAME_DURATION;
static { SENSOR_INFO_MAX_FRAME_DURATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.SizeF> SENSOR_INFO_PHYSICAL_SIZE;
static { SENSOR_INFO_PHYSICAL_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Size> SENSOR_INFO_PIXEL_ARRAY_SIZE;
static { SENSOR_INFO_PIXEL_ARRAY_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Size> SENSOR_INFO_PIXEL_ARRAY_SIZE_MAXIMUM_RESOLUTION;
static { SENSOR_INFO_PIXEL_ARRAY_SIZE_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.graphics.Rect> SENSOR_INFO_PRE_CORRECTION_ACTIVE_ARRAY_SIZE;
static { SENSOR_INFO_PRE_CORRECTION_ACTIVE_ARRAY_SIZE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.graphics.Rect> SENSOR_INFO_PRE_CORRECTION_ACTIVE_ARRAY_SIZE_MAXIMUM_RESOLUTION;
static { SENSOR_INFO_PRE_CORRECTION_ACTIVE_ARRAY_SIZE_MAXIMUM_RESOLUTION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.util.Range<java.lang.Integer>> SENSOR_INFO_SENSITIVITY_RANGE;
static { SENSOR_INFO_SENSITIVITY_RANGE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_INFO_TIMESTAMP_SOURCE;
static { SENSOR_INFO_TIMESTAMP_SOURCE = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_INFO_WHITE_LEVEL;
static { SENSOR_INFO_WHITE_LEVEL = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_MAX_ANALOG_SENSITIVITY;
static { SENSOR_MAX_ANALOG_SENSITIVITY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<android.graphics.Rect[]> SENSOR_OPTICAL_BLACK_REGIONS;
static { SENSOR_OPTICAL_BLACK_REGIONS = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_ORIENTATION;
static { SENSOR_ORIENTATION = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_READOUT_TIMESTAMP;
static { SENSOR_READOUT_TIMESTAMP = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SENSOR_REFERENCE_ILLUMINANT1;
static { SENSOR_REFERENCE_ILLUMINANT1 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Byte> SENSOR_REFERENCE_ILLUMINANT2;
static { SENSOR_REFERENCE_ILLUMINANT2 = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> SHADING_AVAILABLE_MODES;
static { SHADING_AVAILABLE_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES;
static { STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<boolean[]> STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES;
static { STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> STATISTICS_INFO_AVAILABLE_LENS_SHADING_MAP_MODES;
static { STATISTICS_INFO_AVAILABLE_LENS_SHADING_MAP_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> STATISTICS_INFO_AVAILABLE_OIS_DATA_MODES;
static { STATISTICS_INFO_AVAILABLE_OIS_DATA_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> STATISTICS_INFO_MAX_FACE_COUNT;
static { STATISTICS_INFO_MAX_FACE_COUNT = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> SYNC_MAX_LATENCY;
static { SYNC_MAX_LATENCY = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<int[]> TONEMAP_AVAILABLE_TONE_MAP_MODES;
static { TONEMAP_AVAILABLE_TONE_MAP_MODES = null; }

@android.annotation.NonNull public static final android.hardware.camera2.CameraCharacteristics.Key<java.lang.Integer> TONEMAP_MAX_CURVE_POINTS;
static { TONEMAP_MAX_CURVE_POINTS = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Key<T> {

public Key(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.lang.Class<T> type) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

}

