/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.graphics;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class Bitmap implements android.os.Parcelable {

Bitmap() { throw new RuntimeException("Stub!"); }

public int getDensity() { throw new RuntimeException("Stub!"); }

public void setDensity(int density) { throw new RuntimeException("Stub!"); }

public void reconfigure(int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

public void setWidth(int width) { throw new RuntimeException("Stub!"); }

public void setHeight(int height) { throw new RuntimeException("Stub!"); }

public void setConfig(@android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

public void recycle() { throw new RuntimeException("Stub!"); }

public boolean isRecycled() { throw new RuntimeException("Stub!"); }

public int getGenerationId() { throw new RuntimeException("Stub!"); }

public void copyPixelsToBuffer(@android.annotation.NonNull java.nio.Buffer dst) { throw new RuntimeException("Stub!"); }

public void copyPixelsFromBuffer(@android.annotation.NonNull java.nio.Buffer src) { throw new RuntimeException("Stub!"); }

public android.graphics.Bitmap copy(@android.annotation.NonNull android.graphics.Bitmap.Config config, boolean isMutable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Bitmap asShared() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static android.graphics.Bitmap wrapHardwareBuffer(@android.annotation.NonNull android.hardware.HardwareBuffer hardwareBuffer, @android.annotation.Nullable android.graphics.ColorSpace colorSpace) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createScaledBitmap(@android.annotation.NonNull android.graphics.Bitmap src, int dstWidth, int dstHeight, boolean filter) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.graphics.Bitmap src) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.graphics.Bitmap source, int x, int y, int width, int height) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.graphics.Bitmap source, int x, int y, int width, int height, @android.annotation.Nullable android.graphics.Matrix m, boolean filter) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.Nullable android.util.DisplayMetrics display, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config, boolean hasAlpha) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config, boolean hasAlpha, @android.annotation.NonNull android.graphics.ColorSpace colorSpace) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.Nullable android.util.DisplayMetrics display, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config, boolean hasAlpha) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.Nullable android.util.DisplayMetrics display, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config, boolean hasAlpha, @android.annotation.NonNull android.graphics.ColorSpace colorSpace) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull int[] colors, int offset, int stride, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.util.DisplayMetrics display, @android.annotation.NonNull int[] colors, int offset, int stride, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull int[] colors, int width, int height, android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.Nullable android.util.DisplayMetrics display, @android.annotation.NonNull int[] colors, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.graphics.Picture source) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.graphics.Bitmap createBitmap(@android.annotation.NonNull android.graphics.Picture source, int width, int height, @android.annotation.NonNull android.graphics.Bitmap.Config config) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getNinePatchChunk() { throw new RuntimeException("Stub!"); }

public boolean compress(@android.annotation.NonNull android.graphics.Bitmap.CompressFormat format, int quality, @android.annotation.NonNull java.io.OutputStream stream) { throw new RuntimeException("Stub!"); }

public boolean isMutable() { throw new RuntimeException("Stub!"); }

public boolean isPremultiplied() { throw new RuntimeException("Stub!"); }

public void setPremultiplied(boolean premultiplied) { throw new RuntimeException("Stub!"); }

public int getWidth() { throw new RuntimeException("Stub!"); }

public int getHeight() { throw new RuntimeException("Stub!"); }

public int getScaledWidth(@android.annotation.NonNull android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public int getScaledHeight(@android.annotation.NonNull android.graphics.Canvas canvas) { throw new RuntimeException("Stub!"); }

public int getScaledWidth(@android.annotation.NonNull android.util.DisplayMetrics metrics) { throw new RuntimeException("Stub!"); }

public int getScaledHeight(@android.annotation.NonNull android.util.DisplayMetrics metrics) { throw new RuntimeException("Stub!"); }

public int getScaledWidth(int targetDensity) { throw new RuntimeException("Stub!"); }

public int getScaledHeight(int targetDensity) { throw new RuntimeException("Stub!"); }

public int getRowBytes() { throw new RuntimeException("Stub!"); }

public int getByteCount() { throw new RuntimeException("Stub!"); }

public int getAllocationByteCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Bitmap.Config getConfig() { throw new RuntimeException("Stub!"); }

public boolean hasAlpha() { throw new RuntimeException("Stub!"); }

public void setHasAlpha(boolean hasAlpha) { throw new RuntimeException("Stub!"); }

public boolean hasMipMap() { throw new RuntimeException("Stub!"); }

public void setHasMipMap(boolean hasMipMap) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.ColorSpace getColorSpace() { throw new RuntimeException("Stub!"); }

public void setColorSpace(@android.annotation.NonNull android.graphics.ColorSpace colorSpace) { throw new RuntimeException("Stub!"); }

public boolean hasGainmap() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.graphics.Gainmap getGainmap() { throw new RuntimeException("Stub!"); }

public void setGainmap(@android.annotation.Nullable android.graphics.Gainmap gainmap) { throw new RuntimeException("Stub!"); }

public void eraseColor(int c) { throw new RuntimeException("Stub!"); }

public void eraseColor(long color) { throw new RuntimeException("Stub!"); }

public int getPixel(int x, int y) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Color getColor(int x, int y) { throw new RuntimeException("Stub!"); }

public void getPixels(@android.annotation.NonNull int[] pixels, int offset, int stride, int x, int y, int width, int height) { throw new RuntimeException("Stub!"); }

public void setPixel(int x, int y, int color) { throw new RuntimeException("Stub!"); }

public void setPixels(@android.annotation.NonNull int[] pixels, int offset, int stride, int x, int y, int width, int height) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel p, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Bitmap extractAlpha() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.graphics.Bitmap extractAlpha(@android.annotation.Nullable android.graphics.Paint paint, int[] offsetXY) { throw new RuntimeException("Stub!"); }

public boolean sameAs(@android.annotation.Nullable android.graphics.Bitmap other) { throw new RuntimeException("Stub!"); }

public void prepareToDraw() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.hardware.HardwareBuffer getHardwareBuffer() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.graphics.Bitmap> CREATOR;
static { CREATOR = null; }

public static final int DENSITY_NONE = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum CompressFormat {
JPEG,
PNG,
@Deprecated
WEBP,
WEBP_LOSSY,
WEBP_LOSSLESS;
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public enum Config {
ALPHA_8,
RGB_565,
@Deprecated
ARGB_4444,
ARGB_8888,
RGBA_F16,
HARDWARE,
RGBA_1010102;
}

}

