/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.content;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ContentProvider implements android.content.ComponentCallbacks2 {

public ContentProvider() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.content.Context getContext() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.content.Context requireContext() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final java.lang.String getCallingPackage() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.content.AttributionSource getCallingAttributionSource() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final java.lang.String getCallingAttributionTag() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final java.lang.String getCallingPackageUnchecked() { throw new RuntimeException("Stub!"); }

public void onCallingPackageChanged() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public final android.content.ContentProvider.CallingIdentity clearCallingIdentity() { throw new RuntimeException("Stub!"); }

public final void restoreCallingIdentity(@android.annotation.NonNull android.content.ContentProvider.CallingIdentity identity) { throw new RuntimeException("Stub!"); }

protected final void setReadPermission(@android.annotation.Nullable java.lang.String permission) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final java.lang.String getReadPermission() { throw new RuntimeException("Stub!"); }

protected final void setWritePermission(@android.annotation.Nullable java.lang.String permission) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final java.lang.String getWritePermission() { throw new RuntimeException("Stub!"); }

protected final void setPathPermissions(@android.annotation.Nullable android.content.pm.PathPermission[] permissions) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public final android.content.pm.PathPermission[] getPathPermissions() { throw new RuntimeException("Stub!"); }

public abstract boolean onCreate();

public void onConfigurationChanged(android.content.res.Configuration newConfig) { throw new RuntimeException("Stub!"); }

public void onLowMemory() { throw new RuntimeException("Stub!"); }

public void onTrimMemory(int level) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String sortOrder);

@android.annotation.Nullable
public android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs, @android.annotation.Nullable java.lang.String sortOrder, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.database.Cursor query(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String[] projection, @android.annotation.Nullable android.os.Bundle queryArgs, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract java.lang.String getType(@android.annotation.NonNull android.net.Uri uri);

@android.annotation.Nullable
public java.lang.String getTypeAnonymous(@android.annotation.NonNull android.net.Uri uri) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri canonicalize(@android.annotation.NonNull android.net.Uri url) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Uri uncanonicalize(@android.annotation.NonNull android.net.Uri url) { throw new RuntimeException("Stub!"); }

public boolean refresh(android.net.Uri uri, @android.annotation.Nullable android.os.Bundle extras, @android.annotation.Nullable android.os.CancellationSignal cancellationSignal) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.net.Uri insert(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.content.ContentValues values);

@android.annotation.Nullable
public android.net.Uri insert(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.content.ContentValues values, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public int bulkInsert(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull android.content.ContentValues[] values) { throw new RuntimeException("Stub!"); }

public abstract int delete(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs);

public int delete(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public abstract int update(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.content.ContentValues values, @android.annotation.Nullable java.lang.String selection, @android.annotation.Nullable java.lang.String[] selectionArgs);

public int update(@android.annotation.NonNull android.net.Uri uri, @android.annotation.Nullable android.content.ContentValues values, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.ParcelFileDescriptor openFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.ParcelFileDescriptor openFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.res.AssetFileDescriptor openAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.res.AssetFileDescriptor openAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
protected final android.os.ParcelFileDescriptor openFileHelper(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mode) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String[] getStreamTypes(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeTypeFilter) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.res.AssetFileDescriptor openTypedAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeTypeFilter, @android.annotation.Nullable android.os.Bundle opts) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.content.res.AssetFileDescriptor openTypedAssetFile(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeTypeFilter, @android.annotation.Nullable android.os.Bundle opts, @android.annotation.Nullable android.os.CancellationSignal signal) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public <T> android.os.ParcelFileDescriptor openPipeHelper(@android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeType, @android.annotation.Nullable android.os.Bundle opts, @android.annotation.Nullable T args, @android.annotation.NonNull android.content.ContentProvider.PipeDataWriter<T> func) throws java.io.FileNotFoundException { throw new RuntimeException("Stub!"); }

protected boolean isTemporary() { throw new RuntimeException("Stub!"); }

public void attachInfo(android.content.Context context, android.content.pm.ProviderInfo info) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.ContentProviderResult[] applyBatch(@android.annotation.NonNull java.lang.String authority, @android.annotation.NonNull java.util.ArrayList<android.content.ContentProviderOperation> operations) throws android.content.OperationApplicationException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.content.ContentProviderResult[] applyBatch(@android.annotation.NonNull java.util.ArrayList<android.content.ContentProviderOperation> operations) throws android.content.OperationApplicationException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle call(@android.annotation.NonNull java.lang.String authority, @android.annotation.NonNull java.lang.String method, @android.annotation.Nullable java.lang.String arg, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Bundle call(@android.annotation.NonNull java.lang.String method, @android.annotation.Nullable java.lang.String arg, @android.annotation.Nullable android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

public void shutdown() { throw new RuntimeException("Stub!"); }

public void dump(java.io.FileDescriptor fd, java.io.PrintWriter writer, java.lang.String[] args) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CallingIdentity {

CallingIdentity() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface PipeDataWriter<T> {

public void writeDataToPipe(@android.annotation.NonNull android.os.ParcelFileDescriptor output, @android.annotation.NonNull android.net.Uri uri, @android.annotation.NonNull java.lang.String mimeType, @android.annotation.Nullable android.os.Bundle opts, @android.annotation.Nullable T args);
}

}

