/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;

import android.content.Context;
import android.view.View;

/**
 * Encapsulates API which SDK sandbox can use to interact with SDKs loaded into it.
 *
 * <p>SDK has to implement this abstract class to generate an entry point for SDK sandbox to be able
 * to call it through.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class SandboxedSdkProvider {

public SandboxedSdkProvider() { throw new RuntimeException("Stub!"); }

/**
 * Sets the SDK {@link android.content.Context Context} which can then be received using {@link android.app.sdksandbox.SandboxedSdkProvider#getContext()  }. This is called before {@link android.app.sdksandbox.SandboxedSdkProvider#onLoadSdk  } is invoked. No operations requiring a {@link android.content.Context Context} should
 * be performed before then, as {@link android.app.sdksandbox.SandboxedSdkProvider#getContext SandboxedSdkProvider#getContext} will return null until
 * this method has been called.
 *
 * <p>Throws IllegalStateException if a base context has already been set.
 *
 * @param context The new base context.

 * This value cannot be {@code null}.
 */

public final void attachContext(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

/**
 * Return the {@link android.content.Context Context} previously set through {@link android.app.sdksandbox.SandboxedSdkProvider#attachContext SandboxedSdkProvider#attachContext}.
 * This will return null if no context has been previously set.
 */

@android.annotation.Nullable
public final android.content.Context getContext() { throw new RuntimeException("Stub!"); }

/**
 * Does the work needed for the SDK to start handling requests.
 *
 * <p>This function is called by the SDK sandbox after it loads the SDK.
 *
 * <p>SDK should do any work to be ready to handle upcoming requests. It should not do any
 * long-running tasks here, like I/O and network calls. Doing so can prevent the SDK from
 * receiving requests from the client. Additionally, it should not do initialization that
 * depends on other SDKs being loaded into the SDK sandbox.
 *
 * <p>The SDK should not do any operations requiring a {@link android.content.Context Context} object before this method
 * has been called.
 *
 * @param params list of params passed from the client when it loads the SDK. This can be empty.
 * This value cannot be {@code null}.
 * @return Returns a {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk}, passed back to the client. The IBinder used to create
 *     the {@link android.app.sdksandbox.SandboxedSdk SandboxedSdk} object will be used by the client to call into the SDK.
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public abstract android.app.sdksandbox.SandboxedSdk onLoadSdk(@android.annotation.NonNull android.os.Bundle params) throws android.app.sdksandbox.LoadSdkException;

/**
 * Does the work needed for the SDK to free its resources before being unloaded.
 *
 * <p>This function is called by the SDK sandbox manager before it unloads the SDK. The SDK
 * should fail any invocations on the Binder previously returned to the client through {@link android.app.sdksandbox.SandboxedSdk#getInterface  }.
 *
 * <p>The SDK should not do any long-running tasks here, like I/O and network calls.
 */

public void beforeUnloadSdk() { throw new RuntimeException("Stub!"); }

/**
 * Requests a view to be remotely rendered to the client app process.
 *
 * <p>Returns {@link android.view.View View} will be wrapped into {@link android.view.SurfaceControlViewHost.SurfacePackage SurfacePackage}. the resulting {@link android.view.SurfaceControlViewHost.SurfacePackage SurfacePackage} will be sent back to the client application.
 *
 * <p>The SDK should not do any long-running tasks here, like I/O and network calls. Doing so
 * can prevent the SDK from receiving requests from the client.
 *
 * @param windowContext the {@link android.content.Context Context} of the display which meant to show the view
 * This value cannot be {@code null}.
 * @param params list of params passed from the client application requesting the view
 * This value cannot be {@code null}.
 * @param width The view returned will be laid as if in a window of this width, in pixels.
 * @param height The view returned will be laid as if in a window of this height, in pixels.
 * @return a {@link android.view.View View} which SDK sandbox pass to the client application requesting the view
 
 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public abstract android.view.View getView(@android.annotation.NonNull android.content.Context windowContext, @android.annotation.NonNull android.os.Bundle params, int width, int height);
}

