/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.sdksandbox;

import android.os.Bundle;

/** Exception thrown by {@link android.app.sdksandbox.SdkSandboxManager#requestSurfacePackage SdkSandboxManager#requestSurfacePackage} */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RequestSurfacePackageException extends java.lang.Exception {

/**
 * Initializes a {@link android.app.sdksandbox.RequestSurfacePackageException RequestSurfacePackageException} with a result code and a message
 *
 * @param requestSurfacePackageErrorCode The result code.
 * Value is {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR}, or {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED}
 * @param message The detailed message which is saved for later retrieval by the {@link
 *     #getMessage()} method.

 * This value may be {@code null}.
 */

public RequestSurfacePackageException(int requestSurfacePackageErrorCode, @android.annotation.Nullable java.lang.String message) { throw new RuntimeException("Stub!"); }

/**
 * Initializes a {@link android.app.sdksandbox.RequestSurfacePackageException RequestSurfacePackageException} with a result code, a message and a
 * cause.
 *
 * @param requestSurfacePackageErrorCode The result code.
 * Value is {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR}, or {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED}
 * @param message The detailed message which is saved for later retrieval by the {@link
 *     #getMessage()} method.
 * This value may be {@code null}.
 * @param cause The cause of the exception, which is saved for later retrieval by the {@link
 *     #getCause()} method. A null value is permitted, and indicates that the cause is
 *     nonexistent or unknown.
 */

public RequestSurfacePackageException(int requestSurfacePackageErrorCode, @android.annotation.Nullable java.lang.String message, @android.annotation.Nullable java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }

/**
 * Initializes a {@link android.app.sdksandbox.RequestSurfacePackageException RequestSurfacePackageException} with a result code, a message, a cause
 * and extra information.
 *
 * @param requestSurfacePackageErrorCode The result code.
 * Value is {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR}, or {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED}
 * @param message The detailed message which is saved for later retrieval by the {@link
 *     #getMessage()} method.
 * This value may be {@code null}.
 * @param cause The cause of the exception, which is saved for later retrieval by the {@link
 *     #getCause()} method. A null value is permitted, and indicates that the cause is
 *     nonexistent or unknown.
 * @param extraInfo Extra error information. This is empty if there is no such information.

 * This value cannot be {@code null}.
 */

public RequestSurfacePackageException(int requestSurfacePackageErrorCode, @android.annotation.Nullable java.lang.String message, @android.annotation.Nullable java.lang.Throwable cause, @android.annotation.NonNull android.os.Bundle extraInfo) { throw new RuntimeException("Stub!"); }

/**
 * Returns the result code this exception was constructed with.
 *
 * @return The result code from {@link android.app.sdksandbox.SdkSandboxManager#requestSurfacePackage SdkSandboxManager#requestSurfacePackage}

 * Value is {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR}, or {@link android.app.sdksandbox.SdkSandboxManager#REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED}
 */

public int getRequestSurfacePackageErrorCode() { throw new RuntimeException("Stub!"); }

/**
 * Returns the extra error information this exception was constructed with.
 *
 * @return The extra error information Bundle.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.os.Bundle getExtraErrorInformation() { throw new RuntimeException("Stub!"); }
}

