/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 */


package android.app.job;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class JobScheduler {

public JobScheduler() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.job.JobScheduler forNamespace(@android.annotation.NonNull java.lang.String namespace) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

public abstract int schedule(@android.annotation.NonNull android.app.job.JobInfo job);

public abstract int enqueue(@android.annotation.NonNull android.app.job.JobInfo job, @android.annotation.NonNull android.app.job.JobWorkItem work);

public abstract void cancel(int jobId);

public abstract void cancelAll();

public void cancelInAllNamespaces() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract java.util.List<android.app.job.JobInfo> getAllPendingJobs();

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<android.app.job.JobInfo>> getPendingJobsInAllNamespaces() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public abstract android.app.job.JobInfo getPendingJob(int jobId);

public int getPendingJobReason(int jobId) { throw new RuntimeException("Stub!"); }

public boolean canRunUserInitiatedJobs() { throw new RuntimeException("Stub!"); }

public static final int PENDING_JOB_REASON_APP = 1; // 0x1

public static final int PENDING_JOB_REASON_APP_STANDBY = 2; // 0x2

public static final int PENDING_JOB_REASON_BACKGROUND_RESTRICTION = 3; // 0x3

public static final int PENDING_JOB_REASON_CONSTRAINT_BATTERY_NOT_LOW = 4; // 0x4

public static final int PENDING_JOB_REASON_CONSTRAINT_CHARGING = 5; // 0x5

public static final int PENDING_JOB_REASON_CONSTRAINT_CONNECTIVITY = 6; // 0x6

public static final int PENDING_JOB_REASON_CONSTRAINT_CONTENT_TRIGGER = 7; // 0x7

public static final int PENDING_JOB_REASON_CONSTRAINT_DEVICE_IDLE = 8; // 0x8

public static final int PENDING_JOB_REASON_CONSTRAINT_MINIMUM_LATENCY = 9; // 0x9

public static final int PENDING_JOB_REASON_CONSTRAINT_PREFETCH = 10; // 0xa

public static final int PENDING_JOB_REASON_CONSTRAINT_STORAGE_NOT_LOW = 11; // 0xb

public static final int PENDING_JOB_REASON_DEVICE_STATE = 12; // 0xc

public static final int PENDING_JOB_REASON_EXECUTING = -1; // 0xffffffff

public static final int PENDING_JOB_REASON_INVALID_JOB_ID = -2; // 0xfffffffe

public static final int PENDING_JOB_REASON_JOB_SCHEDULER_OPTIMIZATION = 13; // 0xd

public static final int PENDING_JOB_REASON_QUOTA = 14; // 0xe

public static final int PENDING_JOB_REASON_UNDEFINED = 0; // 0x0

public static final int PENDING_JOB_REASON_USER = 15; // 0xf

public static final int RESULT_FAILURE = 0; // 0x0

public static final int RESULT_SUCCESS = 1; // 0x1
}

