/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch.observer;


/**
 * Configures the types, namespaces and other properties that {@link android.app.appsearch.observer.ObserverCallback ObserverCallback} instances
 * match against.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ObserverSpec {

ObserverSpec() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of schema types which observers using this spec will trigger on.
 *
 * <p>If empty, the observers will trigger on all schema types.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }
/** Builder for ObserverSpec instances. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Restricts an observer using this spec to triggering only for documents of one of the
 * provided schema types.
 *
 * <p>If unset, the observer will match documents of all types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.observer.ObserverSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemas) { throw new RuntimeException("Stub!"); }

/**
 * Restricts an observer using this spec to triggering only for documents of one of the
 * provided schema types.
 *
 * <p>If unset, the observer will match documents of all types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.observer.ObserverSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemas) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.observer.ObserverSpec ObserverSpec} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.observer.ObserverSpec build() { throw new RuntimeException("Stub!"); }
}

}

