﻿using System.IO;
using System.Linq;
using System.Collections.Generic;
using NUnit.Framework;
using UnityEngine.SceneManagement;
using UnityEngine.Rendering.Universal;
using UnityEditor.SceneManagement;
using UnityEngine;

namespace Tests
{
    public class ExpectedSceneSettings
    {
        internal static IEnumerable<string> SceneTestCase()
        {
            var scenePaths = Directory.GetFiles("./Assets", "*.unity", SearchOption.AllDirectories);
            foreach (var scenePath in scenePaths)
                yield return scenePath.Substring(2);
        }

        [Test]
        public void GlobalLight2D_HasOnlyOne()
        {
            foreach (var testScene in SceneTestCase())
            {
                Scene scene = EditorSceneManager.OpenScene(testScene);
                var globalLight = GameObject.FindObjectsOfType<Light2D>().Where(light => light.lightType == Light2D.LightType.Global);
                Assert.AreEqual(globalLight.Count(), 1, string.Format("Scene {0} should not have more than one Global Light 2D.", scene.path));
            }
        }

        [Test]
        public void GlobalLight2D_HasShadowsDisabled()
        {
            foreach (var testScene in SceneTestCase())
            {
                Scene scene = EditorSceneManager.OpenScene(testScene);
                var globalLight = GameObject.FindObjectsOfType<Light2D>().Where(light => light.lightType == Light2D.LightType.Global);
                if(globalLight.Any())
                {
                    Light2D light = globalLight.First();
                    Assert.IsFalse(light.shadowsEnabled, string.Format("{0} in {1} should have Shadows disabled.", light.name, scene.path));
                    Assert.IsFalse(light.volumeIntensityEnabled, string.Format("{0} in {1} should have Volumetric Intensity disabled.", light.name, scene.path));
                    Assert.IsFalse(light.volumetricShadowsEnabled, string.Format("{0} in {1} should have Volumetric Shadows disabled.", light.name, scene.path));
                }
            }
        }
    }
}
